package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V dirty SLAC PDU
 *
 *  @author  CCS
 */
public class ComCamPdu24VD extends PduHV {

    /**
     *  Constants and data.
     */

    /*
1 - ion pump
2 - not assigned
3 - path finder turbo pump
4 - path finder filter changer
5 - scroll lab pump (moved to 7)
6 - cryo turbo
7 - not assigned
8 - 
    */
    public static final int
	CHAN_SHUTTER_BRAKE = 0, // J5
        CHAN_FES_LOADER_D  = 1,
        CHAN_PFTURBO       = 2,
        CHAN_FES           = 3, // J8

        CHAN_ION_PUMP      = 4, // J9
        CHAN_CRYO_TURBO    = 5,
        CHAN_PFSCROLL      = 6, // J11

        NUM_CHANS          = 7;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
	//        CHANNEL_MAP.put("ionPump",   CHAN_ION_PUMP);
        CHANNEL_MAP.put("fesLoader", CHAN_FES_LOADER_D);
        CHANNEL_MAP.put("PFTurbo", CHAN_PFTURBO);
        CHANNEL_MAP.put("fes", CHAN_FES);

        CHANNEL_MAP.put("PFScroll", CHAN_PFSCROLL);
        CHANNEL_MAP.put("cryoTurbo", CHAN_CRYO_TURBO);
        CHANNEL_MAP.put("shuBrakes", CHAN_SHUTTER_BRAKE);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x7f;


    /**
     *  Constructor.
     */
    public ComCamPdu24VD()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
