package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 48V ComCam PDU
 *
 *  @author  Owen Saxton
 */
public class ComCamPdu48V extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
	CHAN_UNUSED1       = 0,
        CHAN_UNUSED2       = 1,
        CHAN_CRYOTEL_CTRL0 = 2,
        CHAN_CRYOTEL_CTRL1 = 3,
        CHAN_CRYOTEL_CTRL2 = 4,
        CHAN_UTC           = 5,
        CHAN_REB_BULK      = 6,
        NUM_CHANS          = 7;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("unused1", CHAN_UNUSED1);
        CHANNEL_MAP.put("unused2", CHAN_UNUSED2);
        CHANNEL_MAP.put("cryotelCtrl0", CHAN_CRYOTEL_CTRL0);
        CHANNEL_MAP.put("cryotelCtrl1", CHAN_CRYOTEL_CTRL1);
        CHANNEL_MAP.put("cryotelCtrl2", CHAN_CRYOTEL_CTRL2);
        CHANNEL_MAP.put("utc", CHAN_UTC);
        CHANNEL_MAP.put("REBPS", CHAN_REB_BULK);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_48V);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x07C;


    /**
     *  Constructor.
     */
    public ComCamPdu48V()
    {
        super(NUM_CHANS, LambdaPS.MODEL_48);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
