package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 48V SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class Pdu48V extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_FES_CAROUSEL_D = 0,
        CHAN_UNUSED_48      = 1,
        CHAN_SHUTTER_1_D    = 2,
        CHAN_SHUTTER_2_D    = 3,
        CHAN_PURGE_FAN      = 4,
        CHAN_FES_HEATER     = 5,
        NUM_CHANS           = 6;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("fesCarousel", CHAN_FES_CAROUSEL_D);
        CHANNEL_MAP.put("fesHeater", CHAN_FES_HEATER);
        CHANNEL_MAP.put("shutter1", CHAN_SHUTTER_1_D);
        CHANNEL_MAP.put("shutter2", CHAN_SHUTTER_2_D);
        CHANNEL_MAP.put("purgeFan", CHAN_PURGE_FAN);
        CHANNEL_MAP.put("unused", CHAN_UNUSED_48);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_48V);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x03d;


    /**
     *  Constructor.
     */
    public Pdu48V()
    {
        super(NUM_CHANS, LambdaPS.MODEL_48);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
