package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the 24V clean SLAC PDU
 *
 *  @author  Owen Saxton
 */
public class Pdu24VC extends PduHV {

    /**
     *  Constants and data.
     */
    public static final int
        CHAN_ION_PUMPS     = 0,
        CHAN_UNUSED_24C    = 1,
        CHAN_FES_CHANGER_C = 2,
        CHAN_BPU_MAQ20     = 3,
        CHAN_SHUTTER_1     = 4,
        CHAN_SHUTTER_2     = 5,
        CHAN_FES_CAROUSEL  = 6,
        CHAN_FES_LOADER_C  = 7,
        CHAN_BODY_PURGE    = 8,
        CHAN_GAUGES        = 9,
        CHAN_HCU_PWR_CRY   = 10,
        CHAN_HCU_FES_SHU   = 11,
        NUM_CHANS          = 12;

    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("bodyPurge", CHAN_BODY_PURGE);
        CHANNEL_MAP.put("fesChanger", CHAN_FES_CHANGER_C);
        CHANNEL_MAP.put("fesCarousel", CHAN_FES_CAROUSEL);
        CHANNEL_MAP.put("fesLoader", CHAN_FES_LOADER_C);
        CHANNEL_MAP.put("shutter1", CHAN_SHUTTER_1);
        CHANNEL_MAP.put("shutter2", CHAN_SHUTTER_2);
        CHANNEL_MAP.put("bpuMaq20", CHAN_BPU_MAQ20);
        CHANNEL_MAP.put("ionPumps", CHAN_ION_PUMPS);
        CHANNEL_MAP.put("gauges", CHAN_GAUGES);
        CHANNEL_MAP.put("hcuPwrCry", CHAN_HCU_PWR_CRY);
        CHANNEL_MAP.put("hcuFesShu", CHAN_HCU_FES_SHU);
        CHANNEL_MAP.put("unused", CHAN_UNUSED_24C);
    }

    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(BoardType.SIMULATED);
    }

    private static final int
        VALID_CHAN_MASK = 0x0ffd;


    /**
     *  Constructor.
     */
    public Pdu24VC()
    {
        super(NUM_CHANS, LambdaPS.MODEL_28);
        setValidBoardTypes(VALID_TYPES);
        setValidChannels(VALID_CHAN_MASK);
        setChannelMap(CHANNEL_MAP);
    }

}
