/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.PduHV;
import org.lsst.ccs.drivers.auxelex.TestPduCommon;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestPduHV
extends TestPduCommon {
    private final PduHV pduH;

    public TestPduHV(PduHV pdu) {
        super(pdu);
        this.pduH = pdu;
    }

    @Command(description="Read the board temperature")
    public double readBoardTemp() throws DriverException {
        return this.pduH.readBoardTemperature();
    }

    @Command(description="Read the FPGA temperature")
    public double readFpgaTemp() throws DriverException {
        return this.pduH.readFpgaTemperature();
    }

    @Command(description="Show the main model type")
    public int showMainModel() throws DriverException {
        return this.pduH.getMainModel();
    }

    @Command(description="Show the main serial number")
    public String showMainSerial() throws DriverException {
        return this.pduH.getMainSerialNo();
    }

    @Command(description="Show the main firmware version")
    public String showMainFwVersion() throws DriverException {
        return this.pduH.getMainFwVersion();
    }

    @Command(description="Show the main product version")
    public String showMainPrVersion() throws DriverException {
        return this.pduH.getMainPrVersion();
    }

    @Command(description="Show the main part number")
    public String showMainPartNo() throws DriverException {
        return this.pduH.getMainPartNo();
    }

    @Command(description="Show the main manufacture date")
    public String showMainManuDate() throws DriverException {
        return this.pduH.getMainManuDate();
    }

    @Command(description="Show the main manufacture location")
    public String showMainManuLocn() throws DriverException {
        return this.pduH.getMainManuLocn();
    }

    @Command(description="Read the main status word")
    public int readMainStatus() throws DriverException {
        return this.pduH.readMainStatus();
    }

    @Command(description="Read the main voltage")
    public double readMainVoltage() throws DriverException {
        return this.pduH.readMainVoltage();
    }

    @Command(description="Read the main current")
    public double readMainCurrent() throws DriverException {
        return this.pduH.readMainCurrent();
    }

    @Command(description="Read the main temperature")
    public double readMainTemp() throws DriverException {
        return this.pduH.readMainTemperature();
    }
}

