/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestBfr
extends TestSrp {
    private final Bfr bfr;

    public TestBfr() {
        super(new Bfr());
        this.bfr = (Bfr)this.srp;
    }

    @Command(description="Turn on a relay")
    public void relayOn(@Argument(description="Relay number") int relay) throws DriverException {
        this.bfr.setRelayOn(relay);
    }

    @Command(description="Turn on a named relay")
    public void relayOnN(@Argument(description="Relay name") String relay) throws DriverException {
        this.bfr.setRelayOn(relay);
    }

    @Command(description="Turn on some relays")
    public void relaysOn(int ... relays) throws DriverException {
        this.bfr.setRelayOn(relays);
    }

    @Command(description="Turn on some named relays")
    public void relaysOnN(String ... relays) throws DriverException {
        this.bfr.setRelayOn(relays);
    }

    @Command(description="Turn on all relays")
    public void allRelaysOn() throws DriverException {
        this.bfr.setRelayOn();
    }

    @Command(description="Turn off a relay")
    public void relayOff(@Argument(description="Relay number") int relay) throws DriverException {
        this.bfr.setRelayOff(relay);
    }

    @Command(description="Turn off a named relay")
    public void relayOffN(@Argument(description="Relay name") String relay) throws DriverException {
        this.bfr.setRelayOff(relay);
    }

    @Command(description="Turn off some relays")
    public void relaysOff(int ... relays) throws DriverException {
        this.bfr.setRelayOff(relays);
    }

    @Command(description="Turn off some named relays")
    public void relaysOffN(String ... relays) throws DriverException {
        this.bfr.setRelayOff(relays);
    }

    @Command(description="Turn off all relays")
    public void allRelaysOff() throws DriverException {
        this.bfr.setRelayOff();
    }

    @Command(description="Show the state of a relay")
    public String showRelay(@Argument(description="Relay number") int relay) throws DriverException {
        return this.bfr.isRelayOn(relay) ? "on" : "off";
    }

    @Command(description="Show the state of a named relay")
    public String showRelayN(@Argument(description="Relay name") String relay) throws DriverException {
        return this.bfr.isRelayOn(relay) ? "on" : "off";
    }

    @Command(description="Show the state of all relays")
    public String showRelays() throws DriverException {
        StringBuilder text = new StringBuilder();
        boolean[] states = this.bfr.isRelayOn();
        TestBfr testBfr = this;
        String[] names = testBfr.bfr.getRelayNames();
        for (int relay = 0; relay < 12; ++relay) {
            String prefix = relay == 0 ? "" : (relay % 3 == 0 ? "\n" : "   ");
            text.append(String.format("%s%2s  %-8s%3s", prefix, relay, names[relay], states[relay] ? "on" : "off"));
        }
        return text.toString();
    }

    @Command(description="Show the relay names")
    public static String showRelayNames() throws DriverException {
        StringBuilder text = new StringBuilder();
        String[] names = Bfr.getRelayNames();
        String prefix = "";
        for (String name : names) {
            text.append(prefix).append(name);
            prefix = " ";
        }
        return text.toString();
    }
}

