/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class RebPs
extends Srp {
    public static final int VERSION_PROTO = 0;
    public static final int VERSION_PROD = 1;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SCIENCE = 0;
    public static final int TYPE_CORNER = 1;
    public static final int PS_DIGITAL = 0;
    public static final int PS_ANALOG = 1;
    public static final int PS_OD = 2;
    public static final int PS_CLK_HIGH = 3;
    public static final int PS_CLK_LOW = 4;
    public static final int PS_HEATER = 5;
    public static final int PS_DPHI = 5;
    public static final int PS_HV_BIAS = 6;
    public static final int NUM_PS = 7;
    public static final int CHAN_VOLT_BEF_LDO = 0;
    public static final int CHAN_CURR_BEF_LDO = 1;
    public static final int CHAN_VOLT_AFT_LDO = 2;
    public static final int CHAN_CURR_AFT_LDO = 3;
    public static final int CHAN_VOLT_AFT_SW = 4;
    public static final int CHAN_VOLT2_AFT_LDO = 5;
    public static final int CHAN_VOLT_DAC = -1;
    public static final int NUM_CHAN_EXT = 3;
    public static final int EXT_VALUE_CURR = 0;
    public static final int EXT_VALUE_MAX = 1;
    public static final int EXT_VALUE_MIN = 2;
    public static final int EXT_LIMIT_HIGH = 3;
    public static final int EXT_LIMIT_LOW = 4;
    public static final int NUM_EXT_VALUE = 5;
    public static final int REB_QUANTUM = 3;
    public static final int MAX_REBS = 6;
    private static final int DEVC_LTC2945 = 0;
    private static final int DEVC_MAX11644 = 1;
    private static final int DEVC_MAX5803 = 2;
    private static final int REG_FPGA_VERSION = 0;
    private static final int REG_SCRATCH = 1;
    private static final int REG_SERIAL_NO = 2;
    private static final int REG_GEOG_ADDR = 4;
    private static final int REG_SPARE0 = 5;
    private static final int REG_INIT_STATUS = 16;
    private static final int STATUS_CR = Integer.MIN_VALUE;
    private static final int STATUS_M_REBS = 63;
    private static final int STATUS_V_INIT_FAIL = 0;
    private static final int STATUS_V_INIT_DONE = 8;
    private static final int STATUS_V_BIAS_WAIT = 16;
    private static final int STATUS_V_CNFG_DONE = 24;
    private static final int REG_FAIL_SUMMARY = 17;
    private static final int REG_REB_FAIL_BASE = 18;
    private static final int REG_ENABLE_WRITE = 32;
    private static final int REG_ENABLE_POWER_ON = 33;
    private static final int REG_ENABLE_UNUSED = 34;
    private static final int ENABLE_KEY = -559038737;
    private static final int REG_ENABLE_STATE = 35;
    private static final int ENABLE_V_NOWRITE = 0;
    private static final int ENABLE_V_POWER_ON = 1;
    private static final int REG_DS75LV_WRITE = 224;
    private static final int REG_DS75LV_READ = 225;
    private static final int REG_THRESHOLD = 256;
    private static final int REG_REB_BASE = 65536;
    private static final int REG_REB_INCR = 65536;
    private static final int REG_PS_BASE = 65536;
    private static final int REG_PS_INCR = 4096;
    private static final int REG_DEV_INCR = 256;
    private static final int REG_REB_DATA_BASE = 94208;
    private static final int REG_REB_RDO_PERIOD = 0;
    private static final int REG_REB_RDO_CONFIG = 1;
    private static final int REG_REB_RDO_COUNT = 3;
    private static final int REG_REB_RDO_DIAG_CNT = 4;
    private static final int REG_REB_CHAN_BASE = 94336;
    private static final int SEQ_TIMEOUT = 5000;
    private static final List<Srp.BoardType> validTypes = new ArrayList<Srp.BoardType>();
    private static final int[][] chanDesc;
    private static final int[][] devcDesc;
    private static final int[] dacChannel;
    private static final double[][] convConstProto;
    private static final double[][] convConstProd;
    private static final List<Long> oldUnits;
    private int numRebs;
    private int numTemps;
    private int psVersion;
    private double clockLoAftSwCoeff;
    private double clockLoAftSwCoeff2;
    private static double[][] convConst;
    private final Object tempSync = new Object();
    private static final double[][] simValues;

    public RebPs() {
        this.setValidBoardTypes(validTypes);
        this.setProbeAddress(-1);
    }

    @Override
    public synchronized void open(String ipAddr, int port) throws DriverException {
        super.open(ipAddr, port);
        this.psVersion = 0;
        this.numRebs = 3;
        this.numTemps = 1;
        Srp.BoardType type = this.getBoardType();
        if (type == Srp.BoardType.REB_PS_PROTO || this.isSimulated()) {
            this.setSrpVersion(1);
        } else {
            this.setSrpVersion(3);
            this.psVersion = 1;
            if (type == Srp.BoardType.REB_PS_PROD) {
                this.numRebs += 3;
                this.numTemps = 7;
            }
        }
        try {
            this.readReg(5);
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
        if (this.numRebs > 3) {
            convConst = convConstProd;
            this.clockLoAftSwCoeff = 17.15;
            this.clockLoAftSwCoeff2 = 3.0;
        } else {
            convConst = convConstProto;
            this.clockLoAftSwCoeff = oldUnits.contains(this.getSerialNo()) ? 13.1 : 21.1;
            this.clockLoAftSwCoeff2 = 1.0;
        }
    }

    public int getVersion() {
        return this.psVersion;
    }

    public int getNumRebs() {
        return this.numRebs;
    }

    public int getNumTemperatures() {
        return this.numTemps;
    }

    public int getType() throws DriverException {
        return this.psVersion == 0 ? -1 : ((this.readReg(16) & Integer.MIN_VALUE) == 0 ? 0 : 1);
    }

    public int getFwVersion() throws DriverException {
        return this.readReg(0);
    }

    public long getSerialNo() throws DriverException {
        int[] value = this.readRegs(2, 2);
        return (long)value[1] << 32 | (long)value[0] & 0xFFFFFFFFL;
    }

    public int getGeogAddr() throws DriverException {
        return this.readReg(4);
    }

    public int getInitStatus() throws DriverException {
        return this.psVersion == 1 ? this.readReg(16) : 0;
    }

    public int getFailureSummary() throws DriverException {
        return this.psVersion == 1 ? this.readReg(17) : 0;
    }

    public int getFailureDetail(int rebNum) throws DriverException {
        this.checkRebNumber(rebNum);
        return this.psVersion == 1 ? this.readReg(18 + rebNum) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configTemperature() throws DriverException {
        Object object = this.tempSync;
        synchronized (object) {
            if (this.psVersion == 1) {
                for (int j = 0; j < this.numTemps; ++j) {
                    this.writeReg(224, Integer.MIN_VALUE | j << 20);
                    try {
                        this.getTemperatureRes(j);
                        continue;
                    }
                    catch (DriverException driverException) {
                        // empty catch block
                    }
                }
            } else {
                this.setTemperatureRes(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemperatureRes(int sensor, int value) throws DriverException {
        Object object = this.tempSync;
        synchronized (object) {
            this.checkTempSensor(sensor);
            this.writeDS75LV(sensor, 1, (value & 3) << 5);
            if (this.psVersion == 1) {
                this.getTemperatureRes(sensor);
            }
        }
    }

    public void setTemperatureRes(int value) throws DriverException {
        for (int j = 0; j < this.numTemps; ++j) {
            try {
                this.setTemperatureRes(j, value);
                continue;
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTemperatureRes(int sensor) throws DriverException {
        Object object = this.tempSync;
        synchronized (object) {
            this.checkTempSensor(sensor);
            this.readDS75LV(sensor, 1);
            int value = this.waitDS75LV();
            return value < 0 ? -1 : value >> 13 & 3;
        }
    }

    public int[] getTemperatureRes() throws DriverException {
        int[] values = new int[this.numTemps];
        for (int sensor = 0; sensor < this.numTemps; ++sensor) {
            values[sensor] = this.getTemperatureRes(sensor);
        }
        return values;
    }

    public double readTemperature(int sensor) throws DriverException {
        return this.readTemp(sensor, 0);
    }

    public double[] readTemperature() throws DriverException {
        return this.readTemp(0);
    }

    public double[] readTempWarn() throws DriverException {
        return this.readTemp(2);
    }

    public double[] readTempError() throws DriverException {
        return this.readTemp(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readTemp(int sensor, int addr) throws DriverException {
        Object object = this.tempSync;
        synchronized (object) {
            this.checkTempSensor(sensor);
            this.readDS75LV(sensor, addr);
            int value = this.waitDS75LV();
            return value < 0 ? Double.NaN : (double)(value << 16 >> 16) / 256.0;
        }
    }

    private double[] readTemp(int addr) throws DriverException {
        double[] values = new double[this.numTemps];
        for (int sensor = 0; sensor < this.numTemps; ++sensor) {
            values[sensor] = this.readTemp(sensor, addr);
        }
        return values;
    }

    private void writeDS75LV(int sensor, int reg, int value) throws DriverException {
        boolean oneByte = reg == 1;
        this.writeReg(224, sensor << 20 | (oneByte ? 262144 : 786432) | reg << 16 | (oneByte ? value << 8 : value) & 0xFFFF);
    }

    private void readDS75LV(int sensor, int reg) throws DriverException {
        boolean oneByte = reg == 1;
        this.writeReg(224, sensor << 20 | (oneByte ? 0 : 524288) | reg << 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitDS75LV() throws DriverException {
        Object object = this.tempSync;
        synchronized (object) {
            int value = 0;
            for (int count = 0; count < 100; ++count) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                value = this.readReg(225);
                if ((value & 0xC0000000) != 0) break;
            }
            return (value & Integer.MIN_VALUE) == 0 ? -1 : value & 0xFFFF;
        }
    }

    public void setPower(int rebNum, int value) throws DriverException {
        boolean prevMaster;
        this.checkRebNumber(rebNum);
        int shift = 8 * (rebNum < 3 ? rebNum + 1 : rebNum - 2);
        int powerReg = rebNum < 3 ? 5 : 1;
        int prevValue = this.updateReg(powerReg, 255 << shift, value << shift) >> shift;
        boolean master = (value & 1) != 0;
        boolean bl = prevMaster = (prevValue & 1) != 0;
        if (master ^ prevMaster) {
            if (this.psVersion == 1) {
                boolean isOn;
                int mask = 65537 << rebNum;
                long endTime = System.currentTimeMillis() + 5000L;
                boolean bl2 = isOn = !master;
                while (master ^ isOn && System.currentTimeMillis() < endTime) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    isOn = (mask & this.getInitStatus()) != 0 || master && (mask & this.getFailureSummary()) != 0;
                }
                String errMsg = null;
                if (master ^ isOn) {
                    errMsg = "timed out";
                } else if (master && (((mask = 1 << 0 + rebNum) & this.getInitStatus()) != 0 || (mask & this.getFailureSummary()) != 0)) {
                    errMsg = String.format("failed (0x%08x)", this.getFailureDetail(rebNum));
                }
                if (errMsg != null) {
                    throw new DriverException("REB " + rebNum + " power " + (master ? "on" : "off") + " sequencing " + errMsg);
                }
            } else if (master) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.configure(rebNum);
            }
        }
    }

    public int getPower(int rebNum) throws DriverException {
        this.checkRebNumber(rebNum);
        int shift = 8 * (rebNum < 3 ? rebNum + 1 : rebNum - 2);
        int powerReg = rebNum < 3 ? 5 : 1;
        return this.readReg(powerReg) >> shift & 0xFF;
    }

    public boolean isPowerOn(int rebNum) throws DriverException {
        this.checkRebNumber(rebNum);
        return (this.getPower(rebNum) & 1) != 0;
    }

    public boolean isPowerOn(int rebNum, int psNum) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        return (this.getPower(rebNum) & 1 << psNum + 1) != 0;
    }

    public void configure(int rebNum, int psNum, int devc) throws DriverException {
        if (this.psVersion == 1) {
            return;
        }
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        switch (RebPs.getDeviceType(psNum, devc)) {
            case 0: {
                break;
            }
            case 1: {
                this.writeReg(addr, 0x3DADADA);
                break;
            }
            case 2: {
                this.writeReg(addr + 38, 0);
            }
        }
    }

    public void configure(int rebNum, int psNum) throws DriverException {
        for (int devc = 0; devc < RebPs.getNumDevices(psNum); ++devc) {
            this.configure(rebNum, psNum, devc);
        }
    }

    public void configure(int rebNum) throws DriverException {
        for (int psNum = 0; psNum < 7; ++psNum) {
            this.configure(rebNum, psNum);
        }
    }

    public double readChannel(int rebNum, int psNum, int chan) throws DriverException {
        double value = this.readChanDirect(rebNum, psNum, chan);
        if (psNum == 4 && (chan == 5 || chan == 4)) {
            double mult = chan == 5 ? 1.0 : this.clockLoAftSwCoeff;
            double scale = chan == 5 ? 1.0 : this.clockLoAftSwCoeff2;
            value = mult * (scale * value - this.readChanDirect(rebNum, psNum, 2));
        }
        return value;
    }

    private double readChanDirect(int rebNum, int psNum, int chan) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        chan = RebPs.convChannel(psNum, chan);
        int desc = RebPs.getChanDesc(psNum, chan);
        int devc = desc >> 4 & 0xF;
        int dChan = desc & 0xF;
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        int value = 0;
        switch (RebPs.getDeviceType(psNum, devc)) {
            case 0: {
                int[] data = this.readRegs(addr += 20 + 10 * dChan, 2);
                value = (data[0] & 0xFF) << 4 | (data[1] & 0xFF) >> 4;
                break;
            }
            case 1: {
                value = this.readReg(addr) >> 16 * (1 - dChan) & 0xFFF;
                break;
            }
            case 2: {
                value = this.readReg(addr + 160) >> 4 & 0xFFF;
            }
        }
        return (double)value * this.getConversion(rebNum, psNum, chan);
    }

    public double[] readChannel(int rebNum, int psNum) throws DriverException {
        this.checkRebNumber(rebNum);
        int nChan = RebPs.getNumChannels(psNum);
        double[] values = new double[nChan];
        for (int chan = 0; chan < nChan; ++chan) {
            values[chan] = this.readChannel(rebNum, psNum, chan);
        }
        return values;
    }

    public double[] readChanExtended(int rebNum, int psNum, int chan) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        chan = RebPs.convChannel(psNum, chan);
        int desc = RebPs.getChanDesc(psNum, chan);
        int devc = desc >> 4 & 0xF;
        int dChan = desc & 0xF;
        if (RebPs.getDeviceType(psNum, devc) != 0) {
            throw new DriverException("Channel has no extended data available");
        }
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc) + 20 + 10 * dChan;
        int[] data = this.readRegs(addr, 10);
        double[] value = new double[5];
        double conv = this.getConversion(rebNum, psNum, chan);
        for (int j = 0; j < data.length; j += 2) {
            value[j / 2] = conv * (double)((data[j] & 0xFF) << 4 | (data[j + 1] & 0xFF) >> 4);
        }
        return value;
    }

    public double[][] readChanExtended(int rebNum, int psNum) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        int nChan = 3 - (psNum == 6 ? 1 : 0);
        double[][] value = new double[3][5];
        for (int j = 0; j < nChan; ++j) {
            System.arraycopy(this.readChanExtended(rebNum, psNum, j), 0, value[j], 0, 5);
        }
        return value;
    }

    public void resetChanExtrema(int rebNum, int psNum, int chan) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        chan = RebPs.convChannel(psNum, chan);
        int desc = RebPs.getChanDesc(psNum, chan);
        int devc = desc >> 4 & 0xF;
        int dChan = desc & 0xF;
        if (RebPs.getDeviceType(psNum, devc) != 0) {
            throw new DriverException("Channel has no accessible extended data");
        }
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc) + 20 + 10 * dChan + 2;
        int[] data = new int[]{0, 0, 255, 240};
        boolean writeEnabled = this.isAllWriteEnabled();
        if (!writeEnabled) {
            this.enableAllWrite(true);
        }
        this.writeRegs(addr, data);
        if (!writeEnabled) {
            this.enableAllWrite(false);
        }
    }

    public void writeDac(int rebNum, int psNum, double value) throws DriverException {
        this.checkRebNumber(rebNum);
        RebPs.checkPsNumber(psNum);
        int chan = RebPs.convChannel(psNum, -1);
        int devc = RebPs.getChanDesc(psNum, chan) >> 4;
        int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
        int val = (int)(value / this.getConversion(rebNum, psNum, chan));
        this.writeReg(addr + 160, (val & 0xFFF) << 4);
    }

    public void enableAllWrite(boolean on) throws DriverException {
        if (this.psVersion == 1) {
            this.writeReg(32, on ? -559038737 : 0);
        }
    }

    public boolean isAllWriteEnabled() throws DriverException {
        return this.psVersion == 1 ? (this.readReg(35) & 1) == 0 : true;
    }

    public void enablePowerLeftOn(boolean on) throws DriverException {
        if (this.psVersion == 1) {
            this.writeReg(33, on ? -559038737 : 0);
        }
    }

    public boolean isPowerLeftOnEnabled() throws DriverException {
        return this.psVersion == 1 ? (this.readReg(35) & 2) != 0 : true;
    }

    public static boolean testChannelNumber(int psNum, int chan) throws DriverException {
        return chan >= 0 && chan < RebPs.getNumChannels(psNum);
    }

    public static boolean testPsNumber(int psNum) {
        return psNum >= 0 && psNum < 7;
    }

    public boolean testRebNumber(int rebNum) throws DriverException {
        return rebNum >= 0 && rebNum < this.numRebs;
    }

    private static int getNumDevices(int psNum) throws DriverException {
        RebPs.checkPsNumber(psNum);
        return devcDesc[psNum].length;
    }

    private static int getNumChannels(int psNum) throws DriverException {
        RebPs.checkPsNumber(psNum);
        return chanDesc[psNum].length;
    }

    private static int convChannel(int psNum, int chan) throws DriverException {
        if (chan == -1) {
            chan = dacChannel[psNum];
        }
        if (chan < 0) {
            throw new DriverException("Power supply has no DAC");
        }
        if (chan >= chanDesc[psNum].length) {
            throw new DriverException("Invalid channel for PS");
        }
        return chan;
    }

    private static int getDeviceType(int psNum, int devc) throws DriverException {
        try {
            return devcDesc[psNum][devc];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverException("Invalid device index for PS");
        }
    }

    private static int getChanDesc(int psNum, int chan) throws DriverException {
        return chanDesc[psNum][chan];
    }

    private static int getDevcBaseAddress(int rebNum, int psNum, int devc) throws DriverException {
        return 65536 + 65536 * rebNum + 4096 * psNum + 256 * devc;
    }

    private double getConversion(int rebNum, int psNum, int chan) throws DriverException {
        double conv = Double.NaN;
        if (this.getType() == 1) {
            if (rebNum % 3 == 2 && psNum == 0) {
                conv = chan == 4 ? 0.00599 : (chan == 1 ? 1.923E-4 : (chan == 3 ? 8.47E-4 : conv));
            } else if (chan == 3) {
                conv = psNum == 3 ? 3.4E-4 : (psNum == 5 ? 6.99E-4 : conv);
            }
        }
        return Double.isNaN(conv) ? convConst[psNum][chan] : conv;
    }

    private void checkRebNumber(int rebNum) throws DriverException {
        if (!this.testRebNumber(rebNum)) {
            throw new DriverException("Invalid REB number (" + rebNum + ")");
        }
    }

    private static void checkPsNumber(int psNum) throws DriverException {
        if (!RebPs.testPsNumber(psNum)) {
            throw new DriverException("Invalid PS number (" + psNum + ")");
        }
    }

    private void checkTempSensor(int sensor) throws DriverException {
        if (sensor < 0 || sensor >= this.numTemps) {
            throw new DriverException("Invalid temperature sensor number (" + sensor + ")");
        }
    }

    @Override
    protected void simInitialize() {
        super.simInitialize();
        this.putSimRegMap(5, 0);
        this.putSimRegMap(225, -2147477645);
    }

    @Override
    protected void simWriteRegs(int addr, int[] value, int count) {
        int j = 0;
        while (j < count) {
            if (addr == 5) {
                this.simSwitchPower(this.getSimRegMap(5), value[j]);
            }
            if (addr < 65536 || (addr & 0xFFF) != 256) {
                this.putSimRegMap(addr, value[j]);
            }
            ++j;
            ++addr;
        }
    }

    private void simSwitchPower(int oldSwitch, int newSwitch) {
        int chan = 0;
        for (int changed = (oldSwitch >>= 8) ^ (newSwitch >>= 8); changed != 0; changed >>= 1) {
            if ((changed & 1) != 0) {
                int reb = chan / 8;
                int ps = chan % 8;
                if (ps == 0) {
                    this.simMasterOn(reb, newSwitch >> 8 * reb);
                } else {
                    this.simPsOn(reb, ps - 1, (newSwitch & 1 << chan) != 0);
                }
            }
            ++chan;
        }
    }

    private void simMasterOn(int rebNum, int swtch) {
        boolean on = (swtch & 1) != 0;
        for (int ps = 0; ps < 7; ++ps) {
            boolean psOn = on && (1 << ps + 1 & swtch) != 0;
            int psChan = ps == 6 ? 0 : 4;
            for (int chan = 0; chan < simValues[ps].length; ++chan) {
                if (chan == 3 || chan == 1) continue;
                this.simChanOn(rebNum, ps, chan, chan == psChan ? psOn : on);
            }
        }
    }

    private void simPsOn(int rebNum, int psNum, boolean on) {
        int chan = psNum == 6 ? 0 : 4;
        this.simChanOn(rebNum, psNum, chan, on);
    }

    private void simChanOn(int rebNum, int psNum, int chan, boolean on) {
        double value;
        double d = value = on ? simValues[psNum][chan] : 0.0;
        if (on && psNum == 4) {
            if (chan == 4) {
                value = value / this.clockLoAftSwCoeff + simValues[psNum][2];
            } else if (chan == 5) {
                value += simValues[psNum][2];
            }
        }
        this.simSetChannel(rebNum, psNum, chan, value);
    }

    private void simSetChannel(int rebNum, int psNum, int chan, double value) {
        try {
            chan = RebPs.convChannel(psNum, chan);
            int desc = RebPs.getChanDesc(psNum, chan);
            int devc = desc >> 4 & 0xF;
            int dChan = desc & 0xF;
            int addr = RebPs.getDevcBaseAddress(rebNum, psNum, devc);
            int dacVal = (int)(value / this.getConversion(rebNum, psNum, chan) + 0.5);
            switch (RebPs.getDeviceType(psNum, devc)) {
                case 0: {
                    this.putSimRegMap(addr += dChan == 0 ? 20 : (dChan == 1 ? 30 : 40), dacVal >> 4);
                    this.putSimRegMap(addr + 1, (dacVal & 0xF) << 4);
                    break;
                }
                case 1: {
                    int oldVal = this.getSimRegMap(addr);
                    int mask = 65535 << 16 * dChan;
                    this.putSimRegMap(addr, dacVal << 16 * (1 - dChan) | oldVal & mask);
                    break;
                }
                case 2: {
                    this.putSimRegMap(addr + 160, dacVal >> 4);
                }
            }
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    static {
        validTypes.add(Srp.BoardType.REB_PS_PROTO);
        validTypes.add(Srp.BoardType.REB_PS_UPDATE);
        validTypes.add(Srp.BoardType.REB_PS_PROD);
        chanDesc = new int[][]{{1, 0, 2, 16, 17}, {1, 0, 2, 16, 17}, {1, 0, 2, 16, 18, 17}, {1, 0, 2, 16, 17}, {1, 0, 2, 16, 18, 17}, {1, 0, 2, 16, 17, 32}, {1, 0, 16}};
        devcDesc = new int[][]{{0, 1}, {0, 1}, {0, 0}, {0, 1}, {0, 0}, {0, 1, 2}, {0, 2}};
        dacChannel = new int[]{-1, -1, -1, -1, -1, 5, 2};
        convConstProto = new double[][]{{0.025, 4.9E-4, 0.00352, 0.0014, 0.00305}, {0.025, 4.9E-4, 0.00352, 0.0014, 0.00305}, {0.025, 6.41E-5, 0.0206, 6.41E-5, 0.0206, 0.025}, {0.025, 1.25E-4, 0.00654, 6.17E-4, 0.006}, {0.025, 7.58E-4, 0.00352, 5.31E-4, 5.0E-4, 0.025}, {0.025, 1.25E-4, 0.00654, 7.5E-4, 0.006, 1.0}, {0.025, 2.96E-7, 1.0}};
        convConstProd = new double[][]{{0.025, 4.9E-4, 0.00352, 0.001399, 0.00305}, {0.025, 4.7E-4, 0.00352, 0.002004, 0.00305}, {0.025, 7.58E-5, 0.0206, 7.58E-5, 0.0206, 0.025}, {0.025, 1.58E-4, 0.00654, 8.47E-4, 0.006}, {0.025, 1.923E-4, 0.00352, 1.923E-4, 5.0E-4, 0.025}, {0.025, 1.58E-4, 0.00654, 8.47E-4, 0.006, 1.0}, {0.025, 7.53E-7, 1.0}};
        oldUnits = new ArrayList<Long>();
        oldUnits.add(7705751321591529984L);
        oldUnits.add(30100591099966914L);
        oldUnits.add(7705751323034370560L);
        oldUnits.add(30100591105603010L);
        oldUnits.add(7705751322967261696L);
        oldUnits.add(30100591105340866L);
        convConst = convConstProto;
        simValues = new double[][]{{5.0, 0.0, 5.0, 0.0, 5.0}, {7.0, 0.0, 7.0, 0.0, 7.0}, {40.0, 0.0, 40.0, 0.0, 40.0, 40.0}, {16.0, 0.0, 16.0, 0.0, 16.0}, {16.0, 0.0, 0.0, 0.0, 16.0, 16.0}, {8.0, 0.0, 8.0, 0.0, 8.0}, {0.0, 0.0}};
    }
}

