package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Program to test the low voltage PDU driver
 * 
 *  @author Owen Saxton
 */
public class TestPduHV extends TestPduCommon {

    /**
     *  Fields
     */
    private final PduHV pduH;

    /**
     *  Constructor
     */
    public TestPduHV()
    {
        super(new PduHV());
        pduH = (PduHV)pdu;
    }

    /*
     *  Commands
     */
    @Command(description="Show the main model")
    public int showMainModel() throws DriverException
    {
        return pduH.getMainModel();
    }

    @Command(description="Show the main serial number")
    public String showMainSerial() throws DriverException
    {
        return pduH.getMainSerialNo();
    }

    @Command(description="Show the main firmware version")
    public String showMainFwVersion() throws DriverException
    {
        return pduH.getMainFwVersion();
    }

    @Command(description="Show the main product version")
    public String showMainPrVersion() throws DriverException
    {
        return pduH.getMainPrVersion();
    }

    @Command(description="Show the main part number")
    public String showMainPartNo() throws DriverException
    {
        return pduH.getMainPartNo();
    }

    @Command(description="Show the main manufacture date")
    public String showMainManuDate() throws DriverException
    {
        return pduH.getMainManuDate();
    }

    @Command(description="Show the main manufacture location")
    public String showMainManuLocn() throws DriverException
    {
        return pduH.getMainManuLocn();
    }

    @Command(description="Read the main status word")
    public int readMainStatus() throws DriverException
    {
        return pduH.readMainStatus();
    }

    @Command(description="Read the main voltage")
    public double readMainVoltage() throws DriverException
    {
        return pduH.readMainVoltage();
    }

    @Command(description="Read the main current")
    public double readMainCurrent() throws DriverException
    {
        return pduH.readMainCurrent();
    }

    @Command(description="Read the main temperature")
    public double readMainTemp() throws DriverException
    {
        return pduH.readMainTemperature();
    }

}
