package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Routines for controlling the low-voltage (5V) SLAC PDU 
 *
 *  @author  Owen Saxton
 */
public class PduLV extends PduCommon {

    /**
     *  Private fields
     */
    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<>();
    static {
        CHANNEL_MAP.put("powerHCU", 0);
        CHANNEL_MAP.put("purgeHCU", 1);
        CHANNEL_MAP.put("shutterHCU", 2);
        CHANNEL_MAP.put("fesHCU", 3);
        CHANNEL_MAP.put("cryoHCU", 4);
        CHANNEL_MAP.put("protHCU", 5);
        CHANNEL_MAP.put("otm00", 7);
        CHANNEL_MAP.put("otm10", 8);
        CHANNEL_MAP.put("otm20", 9);
        CHANNEL_MAP.put("otm30", 10);
        CHANNEL_MAP.put("otm40", 11);
        CHANNEL_MAP.put("otm50", 12);
        CHANNEL_MAP.put("otm01", 14);
        CHANNEL_MAP.put("otm11", 15);
        CHANNEL_MAP.put("otm21", 16);
        CHANNEL_MAP.put("otm31", 17);
        CHANNEL_MAP.put("otm41", 18);
        CHANNEL_MAP.put("otm51", 19);
    }
    private static final List<BoardType> VALID_TYPES = new ArrayList<>();
    static {
        VALID_TYPES.add(BoardType.PDU_5V);
    }
    private static final int
        VALID_CHAN_MASK = 0x000fdfbf;
    private static final double
        SHUNT_HCU = 0.0128,
        SHUNT_OTM = 0.0512;
    private static final double[] CURR_SCALES =
       {CURR_SCALE / SHUNT_HCU, CURR_SCALE / SHUNT_HCU, CURR_SCALE / SHUNT_HCU,
        CURR_SCALE / SHUNT_HCU, CURR_SCALE / SHUNT_HCU, CURR_SCALE / SHUNT_HCU,
        1.0,
        CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM,
        CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM,
        1.0,
        CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM,
        CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM, CURR_SCALE / SHUNT_OTM};


    /**
     *  Constructor
     */
    public PduLV()
    {
        setValidBoardTypes(VALID_TYPES);
        setProbeAddress(REG_DEVICE_BASE);
        setValidChannels(VALID_CHAN_MASK);
        setCurrentScales(CURR_SCALES);
        setChannelMap(CHANNEL_MAP);
    }

}
