/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.conv.Convert;

public class PduHV
extends PduCommon {
    public static final int CHAN_BODY_PURGE = 0;
    public static final int CHAN_FES = 1;
    public static final int CHAN_SHUTTER_C = 2;
    public static final int CHAN_CRYOSTAT = 3;
    public static final int CHAN_HEX = 4;
    public static final int CHAN_ION_PUMPS = 5;
    public static final int CHAN_GAUGES = 6;
    public static final int CHAN_NETWORK0 = 7;
    public static final int CHAN_NETWORK1 = 8;
    public static final int CHAN_NETWORK2 = 9;
    public static final int CHAN_CMS600 = 10;
    public static final int CHAN_CRYO_TURBO = 0;
    public static final int CHAN_HEX_TURBO = 1;
    public static final int CHAN_FES1 = 2;
    public static final int CHAN_FES2 = 3;
    public static final int CHAN_SHUTTER_D = 4;
    public static final int CHAN_PURGE_FAN = 0;
    public static final int CHAN_SHUTTER1 = 1;
    public static final int CHAN_SHUTTER2 = 2;
    public static final int MAIN_MODEL_UNKNOWN = -1;
    public static final int MAIN_MODEL_12 = 0;
    public static final int MAIN_MODEL_28 = 1;
    public static final int MAIN_MODEL_48 = 2;
    public static final int MAIN_STATUS_OFF = 1;
    public static final int MAIN_STATUS_DSAB = 2;
    public static final int MAIN_STATUS_IOGB = 4;
    public static final int MAIN_STATUS_OTW = 8;
    public static final int MAIN_STATUS_OTP = 16;
    public static final int MAIN_STATUS_VBAD = 32;
    public static final int MAIN_STATUS_IBAD = 64;
    public static final int MAIN_STATUS_MASK = 127;
    private static final Map<String, Integer> CHANNEL_MAP_24C = new HashMap<String, Integer>();
    private static final Map<String, Integer> CHANNEL_MAP_24D;
    private static final Map<String, Integer> CHANNEL_MAP_48;
    private static final List<Srp.BoardType> VALID_TYPES;
    private static final int VALID_CHAN_MASK_48 = 7;
    private static final int VALID_CHAN_MASK_24D = 31;
    private static final int VALID_CHAN_MASK_24C = 2047;
    private static final double SHUNT_102 = 0.01024;
    private static final double SHUNT_128 = 0.0128;
    private static final double SHUNT_204 = 0.02048;
    private static final double SHUNT_512 = 0.0512;
    private static final double[] CURR_SCALES_48;
    private static final double[] CURR_SCALES_24D;
    private static final double[] CURR_SCALES_24C;
    private static final int MAX_CHANNELS = 12;
    private static final int REG_LAMBDA_BASE = 78848;
    private static final int REG_SERIAL_NO = 78848;
    private static final int REG_FW_VERSION = 78853;
    private static final int REG_PR_VERSION = 78854;
    private static final int REG_VOLTAGE = 78855;
    private static final int REG_CURRENT = 78856;
    private static final int REG_TEMP = 78857;
    private static final int REG_STATUS = 78858;
    private static final int REG_PART_NO = 78859;
    private static final int REG_MANU_DATE = 78862;
    private static final int REG_MANU_LOCN = 78864;
    private static final int LENG_SERIAL_NO = 20;
    private static final int LENG_FW_VERSION = 4;
    private static final int LENG_PR_VERSION = 4;
    private static final int LENG_PART_NO = 12;
    private static final int LENG_MANU_DATE = 8;
    private static final int LENG_MANU_LOCN = 3;
    private static final int ADC_BAD_MASK = -1024;
    private static final Map<String, Integer> MAIN_MODEL_MAP;
    private static final double[] V_SCALES;
    private static final double[] I_SCALES;
    private static final double T_SCALE = 2.048;
    private int mainModel;
    private double vScale;
    private double iScale;

    public PduHV() {
        this.setValidBoardTypes(VALID_TYPES);
        this.setProbeAddress(65536);
    }

    @Override
    public synchronized void open(String host, int port) throws DriverException {
        super.open(host, port);
        Srp.BoardType type = this.getBoardType();
        if (type == Srp.BoardType.PDU_48V) {
            this.setValidChannels(7);
            this.setCurrentScales(CURR_SCALES_48);
            this.setChannelMap(CHANNEL_MAP_48);
        } else if (type == Srp.BoardType.PDU_24V_DIRTY) {
            this.setValidChannels(31);
            this.setCurrentScales(CURR_SCALES_24D);
            this.setChannelMap(CHANNEL_MAP_24D);
        } else {
            this.setValidChannels(2047);
            this.setCurrentScales(CURR_SCALES_24C);
            this.setChannelMap(CHANNEL_MAP_24C);
        }
        this.mainModel = -1;
        try {
            String mName = this.getMainPartNo();
            if (mName.startsWith("CPFE1000FI")) {
                Integer mod = MAIN_MODEL_MAP.get(mName.substring(10));
                int n = this.mainModel = mod == null ? this.mainModel : mod;
            }
            if (this.mainModel == -1) {
                throw new DriverException("Unrecognized Lambda PS model: " + mName);
            }
            this.vScale = V_SCALES[this.mainModel];
            this.iScale = I_SCALES[this.mainModel];
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public int getMainModel() {
        return this.mainModel;
    }

    public String getMainSerialNo() throws DriverException {
        return this.readString(78848, 20);
    }

    public String getMainFwVersion() throws DriverException {
        return this.readString(78853, 4);
    }

    public String getMainPrVersion() throws DriverException {
        return this.readString(78854, 4);
    }

    public String getMainPartNo() throws DriverException {
        return this.readString(78859, 12);
    }

    public String getMainManuDate() throws DriverException {
        return this.readString(78862, 8);
    }

    public String getMainManuLocn() throws DriverException {
        return this.readString(78864, 3);
    }

    public int readMainStatus() throws DriverException {
        return this.readReg(78858) & 0x7F;
    }

    public double readMainVoltage() throws DriverException {
        return PduHV.fixValue(this.readReg(78855)) * this.vScale;
    }

    public double readMainCurrent() throws DriverException {
        return PduHV.fixValue(this.readReg(78856)) * this.iScale;
    }

    public double readMainTemperature() throws DriverException {
        return (PduHV.fixValue(this.readReg(78857)) - 610.0) / 2.048 + 25.0;
    }

    private static double fixValue(int raw) {
        return (raw & 0xFFFFFC00) == 0 ? (double)raw : Double.NaN;
    }

    private String readString(int addr, int leng) throws DriverException {
        int[] words = this.readRegs(addr, (leng + 3) / 4);
        byte[] bytes = new byte[4 * words.length];
        for (int j = 0; j < words.length; ++j) {
            Convert.intToBytesBE((int)words[j], (byte[])bytes, (int)(4 * j));
        }
        return new String(bytes, 0, leng);
    }

    static {
        CHANNEL_MAP_24C.put("bodyPurge", 0);
        CHANNEL_MAP_24C.put("fes", 1);
        CHANNEL_MAP_24C.put("shutter", 2);
        CHANNEL_MAP_24C.put("cryostat", 3);
        CHANNEL_MAP_24C.put("hex", 4);
        CHANNEL_MAP_24C.put("ionPumps", 5);
        CHANNEL_MAP_24C.put("gauges", 6);
        CHANNEL_MAP_24C.put("network0", 7);
        CHANNEL_MAP_24C.put("network1", 8);
        CHANNEL_MAP_24C.put("network2", 9);
        CHANNEL_MAP_24C.put("cms600", 10);
        CHANNEL_MAP_24D = new HashMap<String, Integer>();
        CHANNEL_MAP_24D.put("cryoTurbo", 0);
        CHANNEL_MAP_24D.put("hexTurbo", 1);
        CHANNEL_MAP_24D.put("fes1", 2);
        CHANNEL_MAP_24D.put("fes2", 3);
        CHANNEL_MAP_24D.put("shutter", 4);
        CHANNEL_MAP_48 = new HashMap<String, Integer>();
        CHANNEL_MAP_48.put("purgeFan", 0);
        CHANNEL_MAP_48.put("shutter1", 1);
        CHANNEL_MAP_48.put("shutter2", 2);
        VALID_TYPES = new ArrayList<Srp.BoardType>();
        VALID_TYPES.add(Srp.BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(Srp.BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(Srp.BoardType.PDU_48V);
        CURR_SCALES_48 = new double[]{0.001953125, 0.001953125, 0.001953125};
        CURR_SCALES_24D = new double[]{0.00244140625, 0.001220703125, 0.00244140625, 0.00244140625, 4.8828125E-4};
        CURR_SCALES_24C = new double[]{0.001220703125, 0.001220703125, 0.001220703125, 4.8828125E-4, 4.8828125E-4, 0.001953125, 0.001953125, 4.8828125E-4, 4.8828125E-4, 4.8828125E-4, 4.8828125E-4};
        MAIN_MODEL_MAP = new HashMap<String, Integer>();
        MAIN_MODEL_MAP.put("12", 0);
        MAIN_MODEL_MAP.put("28", 1);
        MAIN_MODEL_MAP.put("48", 2);
        V_SCALES = new double[]{0.01668, 0.03973, 0.06772};
        I_SCALES = new double[]{0.0815, 0.0488, 0.0282};
    }
}

