/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class PeriodicTaskExceptionHandler {
    private boolean skipOverdueExecutions = false;
    private boolean detectLongExecutions = false;
    private volatile int maxFailures = -1;
    private boolean resetFailureCountOnSuccess = true;
    private Level level;

    public void setSkipOverdueExecutions(boolean skipOverdueExecutions) {
        this.skipOverdueExecutions = skipOverdueExecutions;
    }

    public void setDetectLongExecutions(boolean detectLongExecutions) {
        this.detectLongExecutions = detectLongExecutions;
    }

    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }

    public void setResetFailureCountOnSuccess(boolean resetFailureCountOnSuccess) {
        this.resetFailureCountOnSuccess = resetFailureCountOnSuccess;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isSkipOverdueExecutions() {
        return this.skipOverdueExecutions;
    }

    public boolean isDetectLongExecutions() {
        return this.detectLongExecutions;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public boolean isResetFailureCountOnSuccess() {
        return this.resetFailureCountOnSuccess;
    }

    public Level getLevel() {
        return this.level;
    }

    public void onSkippedExecutions(PeriodicTask task, int nSkipped) {
        Logger logger = task.getLogger();
        if (logger != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Periodic task ").append(task.getTaskName()).append(" skipped ").append(nSkipped).append(" executions.");
            logger.log(this.level, sb.toString(), (Object[])null);
        }
    }

    public void onLongExecution(PeriodicTask task) {
        Logger logger = task.getLogger();
        if (logger != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Periodic task ").append(task.getTaskName()).append(" did not finish execution by the end of its period of ");
            sb.append(task.getPeriod(TimeUnit.MILLISECONDS)).append(" milliseconds.");
            logger.log(this.level, sb.toString(), (Object[])null);
        }
    }

    public void onException(PeriodicTask task, Throwable exception) {
        Logger logger = task.getLogger();
        if (logger != null) {
            logger.log(this.level, "Exception thrown by periodic task " + task.getTaskName(), exception);
        }
    }

    public void onFinalException(PeriodicTask task, Throwable exception) {
        Logger logger = task.getLogger();
        if (logger != null) {
            logger.log(this.level, "Exception thrown by periodic task " + task.getTaskName() + ", task terminated.", exception);
        }
    }
}

