/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ftdi.Ftdi;

public class AsciiIOFtdi
implements AsciiIO {
    private static final Map<Integer, Integer> dbitsMap = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> sbitsMap;
    private static final Map<Integer, Integer> parityMap;
    Ftdi ftdi = new Ftdi();
    private int timeout = 0;

    @Override
    public void open(String serial, int baud, int dchars) throws DriverException {
        Integer dataBits = dbitsMap.get(dchars >> 24 & 0xFF);
        if (dataBits == null) {
            throw new DriverException("Invalid number of data bits");
        }
        Integer stopBits = sbitsMap.get(dchars >> 16 & 0xFF);
        if (stopBits == null) {
            throw new DriverException("Invalid number of stop bits");
        }
        Integer parity = parityMap.get(dchars >> 8 & 0xFF);
        if (parity == null) {
            throw new DriverException("Invalid parity");
        }
        int fc = dchars & 0xFF;
        int flowCtrl = ((fc & 1) != 0 ? 256 : 0) | ((fc & 2) != 0 ? 512 : 0) | ((fc & 4) != 0 ? 1024 : 0);
        String[] fields = serial.split(":", 2);
        if (fields.length == 1) {
            this.ftdi.open(0, serial);
        } else {
            this.ftdi.open(fields[0], 0, fields[1]);
        }
        this.ftdi.setBaudrate(baud);
        this.ftdi.setDataCharacteristics(dataBits.intValue(), stopBits.intValue(), parity.intValue());
        this.ftdi.setFlowControl(flowCtrl);
        this.ftdi.enableEvents(1);
    }

    @Override
    public void close() throws DriverException {
        this.ftdi.close();
    }

    @Override
    public void write(byte[] buff, int offset, int leng) throws DriverException {
        this.ftdi.write(buff, offset, leng);
    }

    @Override
    public int read(byte[] buff, int offset, int mleng) throws DriverException {
        int leng;
        if (offset + mleng > buff.length) {
            mleng = buff.length - offset;
        }
        if ((leng = this.ftdi.getQueueStatus()) == 0) {
            if (this.ftdi.awaitEvent(this.timeout) == 0) {
                throw new DriverTimeoutException("Read timed out");
            }
            leng = this.ftdi.getQueueStatus();
        }
        if (leng > mleng) {
            leng = mleng;
        }
        if (leng > 0) {
            leng = this.ftdi.read(buff, offset, leng);
        }
        return leng;
    }

    @Override
    public void flush() throws DriverException {
        int count = this.ftdi.getQueueStatus();
        if (count > 0) {
            byte[] buff = new byte[count];
            this.ftdi.read(buff, 0, count);
        }
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    static {
        dbitsMap.put(1, 7);
        dbitsMap.put(0, 8);
        sbitsMap = new HashMap<Integer, Integer>();
        sbitsMap.put(0, 0);
        sbitsMap.put(1, 2);
        parityMap = new HashMap<Integer, Integer>();
        parityMap.put(0, 0);
        parityMap.put(1, 1);
        parityMap.put(2, 2);
        parityMap.put(3, 3);
        parityMap.put(4, 4);
    }
}

