package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *****************************************************************************
 **
 **  I/O interface for devices using text commands.
 **
 **  @author Owen Saxton
 **
 *****************************************************************************
 */

public interface AsciiIO {

    public void open(String ident, int parm1, int parm2) throws DriverException;

    public void close() throws DriverException;

    public void write(byte[] data) throws DriverException;

    public int read(byte[] data, int offset) throws DriverException;

    public void flush() throws DriverException;

    public void setTimeout(int timeout) throws DriverException;

}
