/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import org.lsst.ccs.drivers.archon.ArchonConfig;

public class ArchonStatus
implements Serializable {
    public int valid;
    public int count;
    public int log;
    public int power;
    public float backplaneTemp;
    public float p2v5I;
    public float p2v5V;
    public float p5vV;
    public float p5vI;
    public float p6vV;
    public float p6vI;
    public float n6vV;
    public float n6vI;
    public float p17vV;
    public float p17vI;
    public float n17vV;
    public float n17vI;
    public float p35vV;
    public float p35vI;
    public float n35vV;
    public float n35vI;
    public float userV;
    public float userI;
    public float heaterV;
    public float heaterI;
    public float V_OD1;
    public float V_OD2;
    public float V_OD3;
    public float V_OD4;
    public float V_OD5;
    public float V_OD6;
    public float V_OD7;
    public float V_OD8;
    public float V_OD9;
    public float V_OD10;
    public float V_OD11;
    public float V_OD12;
    public float V_OD13;
    public float V_OD14;
    public float V_OD15;
    public float V_OD16;
    public float V_RD1;
    public float V_OG1;
    public float I_OD1;
    public float I_OD2;
    public float I_OD3;
    public float I_OD4;
    public float I_OD5;
    public float I_OD6;
    public float I_OD7;
    public float I_OD8;
    public float I_OD9;
    public float I_OD10;
    public float I_OD11;
    public float I_OD12;
    public float I_OD13;
    public float I_OD14;
    public float I_OD15;
    public float I_OD16;
    public float I_RD1;
    public float I_OG1;
    public BoardStatus[] boards;
    private static final long serialVersionUID = 4096596433181205957L;

    public static int pi(Map<String, String> map, String key) {
        return Integer.parseInt(map.get(key));
    }

    public static int pix(Map<String, String> map, String key) {
        return Integer.parseInt(map.get(key), 16);
    }

    public static int pim(Map<String, String> map, int id, String key) {
        String response = map.get("MOD" + id + "/" + key);
        System.out.println("for MOD" + id + "/" + key + " the response is: " + response);
        int stat = 0;
        try {
            stat = Integer.parseInt(response);
        }
        catch (NumberFormatException ex) {
            System.out.println("ERROR! Archon status request not an integer!");
        }
        return stat;
    }

    public static float pf(Map<String, String> map, String key) {
        return Float.parseFloat(map.get(key));
    }

    public static float pfm(Map<String, String> map, int id, String key) {
        return Float.parseFloat(map.get("MOD" + id + "/" + key));
    }

    public static long pl(Map<String, String> map, String key) {
        return Long.parseLong(map.get(key));
    }

    public static long plx(Map<String, String> map, String key) {
        return Long.parseLong(map.get(key), 16);
    }

    public ArchonStatus() {
        this.boards = new BoardStatus[12];
    }

    public ArchonStatus(ArchonConfig config, Map<String, String> map) {
        this.valid = ArchonStatus.pi(map, "VALID");
        this.count = ArchonStatus.pi(map, "COUNT");
        this.log = ArchonStatus.pi(map, "LOG");
        this.power = ArchonStatus.pi(map, "POWER");
        this.backplaneTemp = ArchonStatus.pf(map, "BACKPLANE_TEMP");
        this.p2v5V = ArchonStatus.pf(map, "P2V5_V");
        this.p2v5I = ArchonStatus.pf(map, "P2V5_I");
        this.p5vV = ArchonStatus.pf(map, "P5V_V");
        this.p5vI = ArchonStatus.pf(map, "P5V_I");
        this.p6vV = ArchonStatus.pf(map, "P6V_V");
        this.p6vI = ArchonStatus.pf(map, "P6V_I");
        this.n6vV = ArchonStatus.pf(map, "N6V_V");
        this.n6vI = ArchonStatus.pf(map, "N6V_I");
        this.p17vV = ArchonStatus.pf(map, "P17V_V");
        this.p17vI = ArchonStatus.pf(map, "P17V_I");
        this.n17vV = ArchonStatus.pf(map, "N17V_V");
        this.n17vI = ArchonStatus.pf(map, "N17V_I");
        this.p35vV = ArchonStatus.pf(map, "P35V_V");
        this.p35vI = ArchonStatus.pf(map, "P35V_I");
        this.n35vV = ArchonStatus.pf(map, "N35V_V");
        this.n35vI = ArchonStatus.pf(map, "N35V_I");
        this.userV = ArchonStatus.pf(map, "USER_V");
        this.userI = ArchonStatus.pf(map, "USER_I");
        this.heaterV = ArchonStatus.pf(map, "HEATER_V");
        this.heaterI = ArchonStatus.pf(map, "HEATER_I");
        this.V_OD1 = ArchonStatus.pfm(map, 9, "HVLC_V1");
        this.V_OD2 = ArchonStatus.pfm(map, 9, "HVLC_V2");
        this.V_OD3 = ArchonStatus.pfm(map, 9, "HVLC_V3");
        this.V_OD4 = ArchonStatus.pfm(map, 9, "HVLC_V4");
        this.V_OD5 = ArchonStatus.pfm(map, 9, "HVLC_V5");
        this.V_OD6 = ArchonStatus.pfm(map, 9, "HVLC_V6");
        this.V_OD7 = ArchonStatus.pfm(map, 9, "HVLC_V7");
        this.V_OD8 = ArchonStatus.pfm(map, 9, "HVLC_V8");
        this.V_OD9 = ArchonStatus.pfm(map, 9, "HVLC_V9");
        this.V_OD10 = ArchonStatus.pfm(map, 9, "HVLC_V10");
        this.V_OD11 = ArchonStatus.pfm(map, 9, "HVLC_V11");
        this.V_OD12 = ArchonStatus.pfm(map, 9, "HVLC_V12");
        this.V_OD13 = ArchonStatus.pfm(map, 9, "HVLC_V21");
        this.V_OD14 = ArchonStatus.pfm(map, 9, "HVLC_V22");
        this.V_OD15 = ArchonStatus.pfm(map, 9, "HVLC_V23");
        this.V_OD16 = ArchonStatus.pfm(map, 9, "HVLC_V24");
        this.V_RD1 = ArchonStatus.pfm(map, 9, "HVLC_V20");
        this.V_OG1 = ArchonStatus.pfm(map, 4, "LVLC_V12");
        this.I_OD1 = ArchonStatus.pfm(map, 9, "HVLC_I1");
        this.I_OD2 = ArchonStatus.pfm(map, 9, "HVLC_I2");
        this.I_OD3 = ArchonStatus.pfm(map, 9, "HVLC_I3");
        this.I_OD4 = ArchonStatus.pfm(map, 9, "HVLC_I4");
        this.I_OD5 = ArchonStatus.pfm(map, 9, "HVLC_I5");
        this.I_OD6 = ArchonStatus.pfm(map, 9, "HVLC_I6");
        this.I_OD7 = ArchonStatus.pfm(map, 9, "HVLC_I7");
        this.I_OD8 = ArchonStatus.pfm(map, 9, "HVLC_I8");
        this.I_OD9 = ArchonStatus.pfm(map, 9, "HVLC_I9");
        this.I_OD10 = ArchonStatus.pfm(map, 9, "HVLC_I10");
        this.I_OD11 = ArchonStatus.pfm(map, 9, "HVLC_I11");
        this.I_OD12 = ArchonStatus.pfm(map, 9, "HVLC_I12");
        this.I_OD13 = ArchonStatus.pfm(map, 9, "HVLC_I21");
        this.I_OD14 = ArchonStatus.pfm(map, 9, "HVLC_I22");
        this.I_OD15 = ArchonStatus.pfm(map, 9, "HVLC_I23");
        this.I_OD16 = ArchonStatus.pfm(map, 9, "HVLC_I24");
        this.I_RD1 = ArchonStatus.pfm(map, 9, "HVLC_I20");
        this.I_OG1 = ArchonStatus.pfm(map, 4, "LVLC_I12");
        this.boards = new BoardStatus[12];
        block7: for (int i = 0; i < 12; ++i) {
            switch (config.modules[i].type) {
                case AD: {
                    this.boards[i] = new ADStatus(i + 1, map);
                    continue block7;
                }
                case DRIVER: {
                    this.boards[i] = new DriverStatus(i + 1, map);
                    continue block7;
                }
                case HEATER: {
                    this.boards[i] = new HeaterStatus(i + 1, map);
                    continue block7;
                }
                case HVBIAS: {
                    this.boards[i] = new HVBiasStatus(i + 1, map);
                    continue block7;
                }
                case LVBIAS: {
                    this.boards[i] = new LVBiasStatus(i + 1, map);
                    continue block7;
                }
            }
        }
    }

    public void dump() {
        Field[] ff = ArchonStatus.class.getDeclaredFields();
        try {
            for (Field f : ff) {
                if (f.getType().equals(Float.TYPE)) {
                    System.out.printf("%s = %f\n", f.getName(), Float.valueOf(f.getFloat(this)));
                    continue;
                }
                if (!f.getType().equals(Integer.TYPE)) continue;
                System.out.printf("%s = %d\n", f.getName(), f.getInt(this));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 12; ++i) {
            if (this.boards[i] == null) continue;
            System.out.println("Board " + (i + 1));
            this.boards[i].dump();
        }
    }

    public static class BoardStatus
    implements Serializable {
        public float temperature;
        private static final long serialVersionUID = 210908887271052714L;

        public void dump() {
            System.out.printf("   temperature %2.3f\n", Float.valueOf(this.temperature));
        }

        public BoardStatus(int id, Map<String, String> map) {
            this.temperature = ArchonStatus.pfm(map, id, "TEMP");
        }
    }

    public static class ADStatus
    extends BoardStatus {
        private static final long serialVersionUID = -6862988098182047914L;

        public ADStatus(int id, Map<String, String> map) {
            super(id, map);
        }
    }

    public static class DriverStatus
    extends BoardStatus {
        private static final long serialVersionUID = 4253020001968479029L;

        public DriverStatus(int id, Map<String, String> map) {
            super(id, map);
        }
    }

    public static class HeaterStatus
    extends BoardStatus {
        public float tempA;
        public float tempB;
        public float heaterAOutput;
        public float heaterBOutput;
        public int DInputs = 0;
        public int vac;
        private static final long serialVersionUID = 4261393134690818187L;

        public HeaterStatus(int id, Map<String, String> map) {
            super(id, map);
            this.tempA = ArchonStatus.pfm(map, id, "TEMPA");
            this.tempB = ArchonStatus.pfm(map, id, "TEMPB");
            this.heaterAOutput = ArchonStatus.pfm(map, id, "HEATERAOUTPUT");
            this.heaterBOutput = ArchonStatus.pfm(map, id, "HEATERBOUTPUT");
            if (map.containsKey("DINPUTS")) {
                this.DInputs = (int)ArchonStatus.pfm(map, id, "DINPUTS");
            }
        }

        @Override
        public void dump() {
            super.dump();
            Field[] ff = HeaterStatus.class.getDeclaredFields();
            try {
                for (Field f : ff) {
                    if (f.getType().equals(Float.TYPE)) {
                        System.out.printf("    %s = %f\n", f.getName(), Float.valueOf(f.getFloat(this)));
                        continue;
                    }
                    if (!f.getType().equals(Integer.TYPE)) continue;
                    System.out.printf("    %s = %d\n", f.getName(), f.getInt(this));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class HVBiasStatus
    extends BoardStatus {
        public float[] hvlc_V = new float[24];
        public float[] hvlc_I = new float[24];
        public float[] hvhc_V = new float[6];
        public float[] hvhc_I = new float[6];
        private static final long serialVersionUID = 5596477496468189559L;

        public HVBiasStatus(int id, Map<String, String> map) {
            super(id, map);
            int i;
            for (i = 0; i < 24; ++i) {
                this.hvlc_V[i] = ArchonStatus.pfm(map, id, "HVLC_V" + (i + 1));
                this.hvlc_I[i] = ArchonStatus.pfm(map, id, "HVLC_I" + (i + 1));
            }
            for (i = 0; i < 6; ++i) {
                this.hvhc_V[i] = ArchonStatus.pfm(map, id, "HVHC_V" + (i + 1));
                this.hvhc_I[i] = ArchonStatus.pfm(map, id, "HVHC_I" + (i + 1));
            }
        }

        @Override
        public void dump() {
            int i;
            super.dump();
            for (i = 0; i < 24; ++i) {
                System.out.printf("    HVLC V%d = %f  I%d = %f\n", i, Float.valueOf(this.hvlc_V[i]), i, Float.valueOf(this.hvlc_I[i]));
            }
            for (i = 0; i < 6; ++i) {
                System.out.printf("    HVHC V%d = %f  I%d = %f\n", i, Float.valueOf(this.hvhc_V[i]), i, Float.valueOf(this.hvhc_I[i]));
            }
        }
    }

    public static class LVBiasStatus
    extends BoardStatus {
        public float[] lvlc_V = new float[24];
        public float[] lvlc_I = new float[24];
        public float[] lvhc_V = new float[6];
        public float[] lvhc_I = new float[6];
        private static final long serialVersionUID = 3237985632825573221L;

        public LVBiasStatus(int id, Map<String, String> map) {
            super(id, map);
            int i;
            for (i = 0; i < 24; ++i) {
                this.lvlc_V[i] = ArchonStatus.pfm(map, id, "LVLC_V" + (i + 1));
                this.lvlc_I[i] = ArchonStatus.pfm(map, id, "LVLC_I" + (i + 1));
            }
            for (i = 0; i < 6; ++i) {
                this.lvhc_V[i] = ArchonStatus.pfm(map, id, "LVHC_V" + (i + 1));
                this.lvhc_I[i] = ArchonStatus.pfm(map, id, "LVHC_I" + (i + 1));
            }
        }

        @Override
        public void dump() {
            int i;
            super.dump();
            for (i = 0; i < 24; ++i) {
                System.out.printf("    LVLC V%d = %f  I%d = %f\n", i, Float.valueOf(this.lvlc_V[i]), i, Float.valueOf(this.lvlc_I[i]));
            }
            for (i = 0; i < 6; ++i) {
                System.out.printf("    LVHC V%d = %f  I%d = %f\n", i, Float.valueOf(this.lvhc_V[i]), i, Float.valueOf(this.lvhc_I[i]));
            }
        }
    }
}

