package org.lsst.ccs.drivers.archon;

import java.util.Map;

import org.lsst.ccs.utilities.logging.Logger;

class ArchonConfig {

    private final int backPlaneType;
    private final int backPlaneRev;
    private final String backPlaneVersion;
    private final long backPlaneID;
    private final int moduleMask;
    final ArchonModuleConfig[] modules = new ArchonModuleConfig[12];

    private static final Logger log = Logger.getLogger("org.lsst.ccs.drivers.archon");

    class ArchonModuleConfig {
        ArchonModuleType type;
        long rev;
        String version;
        long id;
    }

    ArchonConfig(Map<String, String> map) {
        backPlaneType = Integer.parseInt(map.get("BACKPLANE_TYPE"));
        backPlaneRev = Integer.parseInt(map.get("BACKPLANE_REV"));
        backPlaneVersion = map.get("BACKPLANE_VERSION");
        backPlaneID = Long.parseLong(map.get("BACKPLANE_ID"), 16);
        moduleMask = Integer.parseInt(map.get("MOD_PRESENT"), 16);

        for (int i = 1; i <= 12; i++) {
            ArchonModuleConfig mod = new ArchonModuleConfig();
            mod.type = ArchonModuleType.forType(Integer.parseInt(map.get("MOD"
                    + i + "_TYPE")));
            mod.rev = Integer.parseInt(map.get("MOD" + i + "_REV"));
            mod.version = map.get("MOD" + i + "_VERSION");
            mod.id = Long.parseLong(map.get("MOD" + i + "_ID"), 16);

            if (((moduleMask & (1 << (i-1))) == 0) != (mod.type == ArchonModuleType.NONE)) {
                log.error("incompatible information on module " + i + " type "
                        + mod.type + " mask " + moduleMask);
            }

            modules[i-1] = mod;
        }
    }

    void dump() {
        System.out.printf("Backplane type %d\n", backPlaneType);
        System.out.printf("Backplane rev %d\n", backPlaneRev);
        System.out.printf("Backplane version %s\n", backPlaneVersion);
        System.out.printf("Backplane ID %x\n", backPlaneID);
        for (int i = 0; i < 12; i++) {
            System.out.printf("  Module %d : %s\n", i+1,
                    modules[i].type.toString());
            if (modules[i].type != ArchonModuleType.NONE) {
                System.out
                        .printf("    Module %d rev : %d\n", i+1, modules[i].rev);
                System.out.printf("    Module %d version : %s\n", i+1,
                        modules[i].version);
                System.out.printf("    Module %d id : %x\n", i+1, modules[i].id);
            }
        }
        System.out.println();
    }

    public int getBackPlaneType() {
        return backPlaneType;
    }

    public int getBackPlaneRev() {
        return backPlaneRev;
    }

    public String getBackPlaneVersion() {
        return backPlaneVersion;
    }

    public long getBackPlaneID() {
        return backPlaneID;
    }
    
    
}
