package org.lsst.ccs.drivers.archon;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A dummy ArchonController which can be used for testing the Archon Subsystem
 * when no real archon controller is available. Currently has the minimal
 * functionality required by the archon subsystem.
 *
 * @author tonyj
 */
public class DummyArchonController implements ArchonController {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.drivers.archon");

    @Override
    public RawImageData fetchNewImage(long timeout) throws DriverException,
            TimeoutException {
        return RawImageData.createTestImage(CCDType.E2V.getGeometry());
    }

    @Override
    public ArchonStatus getStatus() throws DriverException {
        ArchonStatus s = new ArchonStatus();
        s.backplaneTemp = 31.4f;
        return s;
    }

    @Override
    public void powerOff() throws DriverException {
        log.info("Power Off");
    }

    @Override
    public void powerOn() throws DriverException {
        log.info("Power On");
    }

    @Override
    public void writeConfigLines(String[] lines) throws DriverException {
    }

    @Override
    public void writeConfigLine(int i, String line) throws DriverException {
    }

    @Override
    public void applyAll() throws DriverException {
    }

    @Override
    public void applyMod(int module) throws DriverException {
    }

    @Override
    public void resetTiming() throws DriverException {
    }

    @Override
    public void loadParam(String p) throws DriverException {
    }

    @Override
    public void loadParams() throws DriverException {
    }

    @Override
    public void loadTiming() throws DriverException {
    }

    @Override
    public void pollOff() throws DriverException {
    }

    @Override
    public void pollOn() throws DriverException {
    }
    
    public int getBackPlaneType() {
        return(1);
    }
    
    public int getBackPlaneRev() {
        return(3);
    }
    
    public String getBackPlaneVersion() {
        return("1.0.762");
    }
    
    public long getBackPlaneID() {
        return(Long.decode("0x6ca8867071b050"));
    }

    public void markFrame() throws DriverException {
    }

}
