/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.util.Map;
import org.lsst.ccs.drivers.archon.ArchonModuleType;
import org.lsst.ccs.utilities.logging.Logger;

class ArchonConfig {
    private final int backPlaneType;
    private final int backPlaneRev;
    private final String backPlaneVersion;
    private final long backPlaneID;
    private final int moduleMask;
    final ArchonModuleConfig[] modules = new ArchonModuleConfig[12];
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.archon");

    ArchonConfig(Map<String, String> map) {
        this.backPlaneType = Integer.parseInt(map.get("BACKPLANE_TYPE"));
        this.backPlaneRev = Integer.parseInt(map.get("BACKPLANE_REV"));
        this.backPlaneVersion = map.get("BACKPLANE_VERSION");
        this.backPlaneID = Long.parseLong(map.get("BACKPLANE_ID"), 16);
        this.moduleMask = Integer.parseInt(map.get("MOD_PRESENT"), 16);
        int i = 1;
        while (i <= 12) {
            ArchonModuleConfig mod = new ArchonModuleConfig();
            mod.type = ArchonModuleType.forType(Integer.parseInt(map.get("MOD" + i + "_TYPE")));
            mod.rev = Integer.parseInt(map.get("MOD" + i + "_REV"));
            mod.version = map.get("MOD" + i + "_VERSION");
            mod.id = Long.parseLong(map.get("MOD" + i + "_ID"), 16);
            if ((this.moduleMask & 1 << i - 1) == 0 != (mod.type == ArchonModuleType.NONE)) {
                log.error((Object)("incompatible information on module " + i + " type " + (Object)((Object)mod.type) + " mask " + this.moduleMask));
            }
            this.modules[i - 1] = mod;
            ++i;
        }
    }

    void dump() {
        System.out.printf("Backplane type %d\n", this.backPlaneType);
        System.out.printf("Backplane rev %d\n", this.backPlaneRev);
        System.out.printf("Backplane version %s\n", this.backPlaneVersion);
        System.out.printf("Backplane ID %x\n", this.backPlaneID);
        int i = 0;
        while (i < 12) {
            System.out.printf("  Module %d : %s\n", i + 1, this.modules[i].type.toString());
            if (this.modules[i].type != ArchonModuleType.NONE) {
                System.out.printf("    Module %d rev : %d\n", i + 1, this.modules[i].rev);
                System.out.printf("    Module %d version : %s\n", i + 1, this.modules[i].version);
                System.out.printf("    Module %d id : %x\n", i + 1, this.modules[i].id);
            }
            ++i;
        }
        System.out.println();
    }

    public int getBackPlaneType() {
        return this.backPlaneType;
    }

    public int getBackPlaneRev() {
        return this.backPlaneRev;
    }

    public String getBackPlaneVersion() {
        return this.backPlaneVersion;
    }

    public long getBackPlaneID() {
        return this.backPlaneID;
    }

    class ArchonModuleConfig {
        ArchonModuleType type;
        long rev;
        String version;
        long id;

        ArchonModuleConfig() {
        }
    }
}

