/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Random;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDTransform;

public class RawImageData {
    int width;
    int height;
    Sample sample;
    FrameMode frameMode;
    long timestamp;
    long frame;
    byte[] data;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Sample getSample() {
        return this.sample;
    }

    public FrameMode getFrameMode() {
        return this.frameMode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFrame() {
        return this.frame;
    }

    public static RawImageData createTestImage(CCDGeometry geom) {
        RawImageData testData = new RawImageData();
        testData.sample = Sample.BIT16;
        testData.frameMode = FrameMode.SPLIT;
        testData.timestamp = System.currentTimeMillis();
        testData.height = geom.getTotalParallelSize();
        testData.width = geom.getTotalSerialSize();
        testData.data = new byte[testData.width * testData.height * 2];
        CCDTransform t = geom.getGlobalTransform();
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer sb = bb.asShortBuffer();
        Random random = new Random();
        int j = 0;
        while (j < testData.height) {
            int i = 0;
            while (i < testData.width) {
                t.setXY(i, j);
                sb.put(t.getPixelType() == CCDTransform.PixelType.ACTIVE ? (short)(100 + 2 * i + 3 * j) : (short)Math.round(100.0 + 10.0 * random.nextGaussian()));
                ++i;
            }
            ++j;
        }
        return testData;
    }

    public static RawImageData createRippledImage(CCDGeometry geom) {
        RawImageData testData = new RawImageData();
        testData.sample = Sample.BIT16;
        testData.frameMode = FrameMode.SPLIT;
        testData.timestamp = System.currentTimeMillis();
        testData.height = geom.getTotalParallelSize();
        testData.width = geom.getTotalSerialSize();
        testData.data = new byte[testData.width * testData.height * 2];
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer sb = bb.asShortBuffer();
        Random random = new Random();
        while (sb.hasRemaining()) {
            sb.put((short)Math.round(100.0 + 10.0 * random.nextGaussian()));
        }
        sb.clear();
        CCDTransform t = geom.getActiveTransform();
        int j = 0;
        while (j < geom.getActiveSerialSize()) {
            int i = 0;
            while (i < geom.getActiveParallelSize()) {
                double r = Math.sqrt(Math.pow(j - geom.getActiveSerialSize() / 2, 2.0) + Math.pow(i - geom.getActiveParallelSize() / 2, 2.0));
                t.setXY(i, j);
                sb.put(t.getGlobalY() + t.getGlobalX() * geom.getTotalSerialSize(), (short)Math.round(1000.0 + 200.0 * Math.sin(r / 30.0)));
                ++i;
            }
            ++j;
        }
        return testData;
    }

    public static RawImageData createTestImage(Path rawFile, CCDGeometry geom) throws IOException {
        RawImageData testData = new RawImageData();
        testData.sample = Sample.BIT16;
        testData.frameMode = FrameMode.SPLIT;
        testData.timestamp = System.currentTimeMillis();
        testData.height = geom.getTotalParallelSize();
        testData.width = geom.getTotalSerialSize();
        testData.data = new byte[testData.width * testData.height * 2];
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Throwable throwable = null;
        Object var6_7 = null;
        try (SeekableByteChannel newByteChannel = Files.newByteChannel(rawFile, options, new FileAttribute[0]);){
            assert (newByteChannel.size() == (long)(testData.width * testData.height * 2));
            newByteChannel.read(bb);
            return testData;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum FrameMode {
        TOP,
        BOTTOM,
        SPLIT;

    }

    public static enum Sample {
        BIT16(2),
        BIT32(4);

        private final int bytes;

        private Sample(int bytes) {
            this.bytes = bytes;
        }

        public int bytes() {
            return this.bytes;
        }

        public int bits() {
            return 8 * this.bytes;
        }
    }
}

