/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.util.HashMap;
import java.util.Map;

public enum PrimitiveTypeEnum {
    BYTE(1, false, Byte.TYPE, Byte.class, 'B'),
    SHORT(2, false, Short.TYPE, Short.class, 'S'),
    CHAR(2, false, Character.TYPE, Character.class, 'C'),
    INT(4, false, Integer.TYPE, Integer.class, 'I'),
    LONG(8, false, Long.TYPE, Long.class, 'J'),
    FLOAT(4, false, Float.TYPE, Float.class, 'F'),
    DOUBLE(8, false, Double.TYPE, Double.class, 'D'),
    BOOLEAN(1, false, Boolean.TYPE, Boolean.class, 'Z'),
    STRING(0, true, (Class)CharSequence.class, (Class)String.class, 'L'){

        @Override
        public int size(Object instance) {
            if (instance == null) {
                return 0;
            }
            return ((CharSequence)instance).length();
        }
    }
    ,
    UNKNOWN(0, true, (Class)Object.class, (Class)Object.class, 'L'){

        @Override
        public int size(Object instance) {
            return 0;
        }
    };

    private static Map<Class<?>, PrimitiveTypeEnum> lookup;
    private final int size;
    private final boolean individualSize;
    private final Class<?> primitiveClass;
    private final Class<?> wrapperClass;
    private final char type;

    private static synchronized Map<Class<?>, PrimitiveTypeEnum> getLookup() {
        if (lookup == null) {
            lookup = new HashMap();
            for (PrimitiveTypeEnum primitiveTypeEnum : PrimitiveTypeEnum.values()) {
                lookup.put(primitiveTypeEnum.primitiveClass, primitiveTypeEnum);
                lookup.put(primitiveTypeEnum.wrapperClass, primitiveTypeEnum);
            }
        }
        return lookup;
    }

    public static PrimitiveTypeEnum valueOf(Class<?> clazz) {
        PrimitiveTypeEnum primitiveTypeEnum = PrimitiveTypeEnum.getLookup().get(clazz);
        if (primitiveTypeEnum == null) {
            for (Class<?> interf : clazz.getInterfaces()) {
                primitiveTypeEnum = PrimitiveTypeEnum.getLookup().get(interf);
                if (primitiveTypeEnum == null) continue;
                return primitiveTypeEnum;
            }
            return UNKNOWN;
        }
        return primitiveTypeEnum;
    }

    private PrimitiveTypeEnum(int size, boolean individualSize, Class<?> primitiveClass, Class<?> wrapperClass, char type) {
        this.size = size;
        this.individualSize = individualSize;
        this.primitiveClass = primitiveClass;
        this.wrapperClass = wrapperClass;
        this.type = type;
    }

    public boolean individualSize() {
        return this.individualSize;
    }

    public int size() {
        return this.size;
    }

    public int size(Object instance) {
        if (instance == null) {
            return 0;
        }
        return this.size;
    }

    public char type() {
        return this.type;
    }
}

