/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class RawImageData {
    int width;
    int height;
    Sample sample;
    FrameMode frameMode;
    long timestamp;
    long frame;
    byte[] data;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Sample getSample() {
        return this.sample;
    }

    public FrameMode getFrameMode() {
        return this.frameMode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFrame() {
        return this.frame;
    }

    public static RawImageData createTestImage() {
        RawImageData testData = new RawImageData();
        testData.sample = Sample.BIT16;
        testData.frameMode = FrameMode.SPLIT;
        testData.timestamp = System.currentTimeMillis();
        testData.height = 4096;
        testData.width = 4352;
        testData.data = new byte[testData.width * testData.height * 2];
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer sb = bb.asShortBuffer();
        int j = 0;
        while (j < testData.height) {
            int i = 0;
            while (i < testData.width) {
                sb.put((short)(RawImageData.isOverScan(i, j) ? 50 : 100 + 2 * i + 3 * j));
                ++i;
            }
            ++j;
        }
        return testData;
    }

    public static RawImageData createTestImage(Path rawFile) throws IOException {
        RawImageData testData = new RawImageData();
        testData.sample = Sample.BIT16;
        testData.frameMode = FrameMode.SPLIT;
        testData.timestamp = System.currentTimeMillis();
        testData.height = 4096;
        testData.width = 4352;
        testData.data = new byte[testData.width * testData.height * 2];
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Throwable throwable = null;
        Object var5_6 = null;
        try (SeekableByteChannel newByteChannel = Files.newByteChannel(rawFile, options, new FileAttribute[0]);){
            newByteChannel.read(bb);
            return testData;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isOverScan(int i, int j) {
        return (i %= 544) < 10 || i >= 522 || (j %= 2048) >= 2002;
    }

    public static enum FrameMode {
        TOP,
        BOTTOM,
        SPLIT;

    }

    public static enum Sample {
        BIT16(2),
        BIT32(4);

        private final int bytes;

        private Sample(int bytes) {
            this.bytes = bytes;
        }

        public int bytes() {
            return this.bytes;
        }

        public int bits() {
            return 8 * this.bytes;
        }
    }
}

