/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.drivers.archon.ArchonConfig;
import org.lsst.ccs.drivers.archon.ArchonController;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.logging.Logger;

public class ArchonControllerDriver
implements ArchonController {
    private String ip = "10.0.0.2";
    private int port = 4242;
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.drivers.archon");
    private Socket sock;
    private BufferedOutputStream out;
    private InputStream in;
    private DataInputStream inBin;
    private BufferedReader inString;
    private int cmdId = 0;
    private final Charset csLatin1 = Charset.forName("ISO-8859-1");
    private ArchonConfig config;
    private ArchonStatus status;
    int lastFrame = 0;

    public ArchonControllerDriver() throws DriverException {
        this.init();
    }

    public ArchonControllerDriver(String ip) throws DriverException {
        this.ip = ip;
        this.init();
    }

    public ArchonControllerDriver(String ip, int port) throws DriverException {
        this.ip = ip;
        this.port = port;
        this.init();
    }

    private void init() throws DriverException {
        this.openComm();
        this.readConfig();
        this.readStatus();
    }

    private void openComm() throws DriverException {
        try {
            this.sock = new Socket(this.ip, this.port);
            this.sock.setSoTimeout(5000);
            this.in = this.sock.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(this.in);
            this.inBin = new DataInputStream(bis);
            this.inString = new BufferedReader(new InputStreamReader((InputStream)bis, this.csLatin1));
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (IOException e) {
            this.in = null;
            this.inBin = null;
            this.inString = null;
            this.out = null;
            this.sock = null;
            throw new DriverException("error opening socket to Archon controller", (Throwable)e);
        }
    }

    private void closeComm() throws DriverException {
        try {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                throw new DriverException("error closing streams to Archon controller", (Throwable)e);
            }
        }
        finally {
            try {
                try {
                    this.sock.close();
                }
                catch (IOException e) {
                    throw new DriverException("error closing socket to Archon controller", (Throwable)e);
                }
            }
            finally {
                this.in = null;
                this.inBin = null;
                this.inString = null;
                this.out = null;
                this.sock = null;
            }
        }
    }

    private String sendCommand(String cmd) throws DriverException {
        ++this.cmdId;
        if (this.cmdId >= 256) {
            this.cmdId = 1;
        }
        if (this.sock == null) {
            this.openComm();
        }
        String cmdLine = String.format(">%02X%s\r", this.cmdId, cmd);
        log.debug((Object)cmdLine, new String[0]);
        new DataInputStream(new BufferedInputStream(this.in));
        try {
            this.out.write(cmdLine.getBytes(this.csLatin1));
            this.out.flush();
            while (true) {
                String rep;
                if ((rep = this.inString.readLine()).startsWith("<")) {
                    int seq = Integer.parseInt(rep.substring(1, 3), 16);
                    if (seq < this.cmdId) {
                        log.warn((Object)("out of sequence answer, got " + seq + " expecting " + this.cmdId), new String[0]);
                        continue;
                    }
                    if (seq > this.cmdId) {
                        log.warn((Object)("out of sequence answer, got " + seq + " expecting " + this.cmdId), new String[0]);
                        throw new DriverException("out of sequence answer, got " + seq + " expecting " + this.cmdId);
                    }
                    return rep.substring(3);
                }
                if (rep.startsWith("?")) {
                    log.error((Object)("Archon could not parse " + rep), new String[0]);
                    throw new DriverException("Archon could not parse " + rep);
                }
                log.warn((Object)("Archon invalid answer " + (rep.length() > 5 ? rep.substring(0, 5) : rep) + "..."), new String[0]);
            }
        }
        catch (IOException e) {
            throw new DriverException("Exception sending command to Archon controller", (Throwable)e);
        }
    }

    public byte[] sendBinCommand(String cmd, int nBlocks) throws DriverException {
        byte[] rep = new byte[nBlocks * 1024];
        this.sendBinCommand(cmd, nBlocks, rep);
        return rep;
    }

    public void sendBinCommand(String cmd, int nBlocks, byte[] rep) throws DriverException {
        ++this.cmdId;
        if (this.cmdId >= 256) {
            this.cmdId = 1;
        }
        if (this.sock == null) {
            this.openComm();
        }
        String cmdLine = String.format(">%02X%s\r", this.cmdId, cmd);
        log.info((Object)cmdLine, new String[0]);
        int repsz = rep.length;
        byte[] buf = new byte[1028];
        int i = 0;
        log.info((Object)("expecting " + rep.length + " in " + nBlocks + " blocks"), new String[0]);
        try {
            this.out.write(cmdLine.getBytes(this.csLatin1));
            this.out.flush();
            while (true) {
                this.inBin.readFully(buf);
                if (buf[0] == 60) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)buf[1]);
                    sb.append((char)buf[2]);
                    int seq = Integer.parseInt(sb.toString(), 16);
                    if (seq < this.cmdId) {
                        log.warn((Object)("out of sequence answer, got " + seq + "(" + (char)buf[1] + ":" + (char)buf[2] + ")" + " expecting " + this.cmdId), new String[0]);
                        continue;
                    }
                    if (seq > this.cmdId) {
                        log.warn((Object)("out of sequence answer, got " + seq + "(" + (char)buf[1] + ":" + (char)buf[2] + ")" + " expecting " + this.cmdId), new String[0]);
                        throw new DriverException("out of sequence answer, got " + seq + " expecting " + this.cmdId);
                    }
                    if (buf[3] != 58) {
                        log.warn((Object)("Archon invalid answer " + (char)buf[0] + (char)buf[1] + (char)buf[2] + (char)buf[3] + (char)buf[4] + "..."), new String[0]);
                        continue;
                    }
                    int len = 1024;
                    if (i * 1024 + len > repsz) {
                        len = repsz - i * 1024;
                    }
                    System.arraycopy(buf, 4, rep, i * 1024, len);
                    if (++i != nBlocks) continue;
                    return;
                }
                if (buf[0] == 63) {
                    log.error((Object)("Archon could not parse command " + new String(buf)), new String[0]);
                    throw new DriverException("Archon could not parse command " + new String(buf));
                }
                log.warn((Object)("Archon invalid answer " + (char)buf[0] + (char)buf[1] + (char)buf[2] + (char)buf[3] + (char)buf[4] + "..."), new String[0]);
            }
        }
        catch (IOException e) {
            throw new DriverException("Exception sending command to Archon controller", (Throwable)e);
        }
    }

    protected Map<String, String> parseKeys(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = s.split(" +");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String kv = stringArray[n2];
            String[] kvv = kv.split("=");
            map.put(kvv[0], kvv[1]);
            ++n2;
        }
        return map;
    }

    public void readConfig() throws DriverException {
        Map<String, String> m = this.parseKeys(this.sendCommand("SYSTEM"));
        this.config = new ArchonConfig(m);
    }

    public void readStatus() throws DriverException {
        Map<String, String> m = this.parseKeys(this.sendCommand("STATUS"));
        if (this.config == null) {
            this.readConfig();
        }
        this.status = new ArchonStatus(this.config, m);
    }

    @Override
    public ArchonStatus getStatus() throws DriverException {
        this.readStatus();
        return this.status;
    }

    public FrameStatus getFrameStatus() throws DriverException {
        FrameStatus f = new FrameStatus();
        Map<String, String> m = this.parseKeys(this.sendCommand("FRAME"));
        f.timer = ArchonStatus.plx(m, "TIMER");
        f.rBuf = ArchonStatus.pi(m, "RBUF");
        f.wBuf = ArchonStatus.pi(m, "WBUF");
        int i = 0;
        while (i < 3) {
            f.bufSample[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "SAMPLE");
            f.bufComplete[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "COMPLETE");
            f.bufMode[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "MODE");
            f.bufFrame[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "FRAME");
            f.bufWidth[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "WIDTH");
            f.bufHeight[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "HEIGHT");
            f.bufPixels[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "PIXELS");
            f.bufLines[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "LINES");
            f.bufRawBlocks[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "RAWBLOCKS");
            f.bufRawLines[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "RAWLINES");
            f.bufRawOffset[i] = ArchonStatus.pi(m, "BUF" + (i + 1) + "RAWOFFSET");
            f.butTimeStamp[i] = ArchonStatus.plx(m, "BUF" + (i + 1) + "TIMESTAMP");
            ++i;
        }
        return f;
    }

    public String fetchLog() throws DriverException {
        return this.sendCommand("FETCHLOG");
    }

    public void lock(int n) throws DriverException {
        this.sendCommand("LOCK" + n);
    }

    public void reboot() throws DriverException {
        this.sendCommand("REBOOT");
    }

    public byte[] fetch(int startAddr, int nBlocks) throws DriverException {
        String cmd = String.format("FETCH%08X%08X", startAddr, nBlocks);
        return this.sendBinCommand(cmd, nBlocks);
    }

    public void fetch(int startAddr, byte[] rep) throws DriverException {
        int nBlocks = (rep.length + 1023) / 1024;
        String cmd = String.format("FETCH%08X%08X", startAddr, nBlocks);
        this.sendBinCommand(cmd, nBlocks, rep);
    }

    public String readConfigLine(int i) throws DriverException {
        if (i < 0 || i > 2047) {
            throw new ArrayIndexOutOfBoundsException("config line out of range " + i);
        }
        return this.sendCommand(String.format("RCONFIG%04X", i));
    }

    public void writeConfigLine(int i, String line) throws DriverException {
        if (i < 0 || i > 2047) {
            throw new ArrayIndexOutOfBoundsException("config line out of range " + i);
        }
        if (line.length() > 2048) {
            throw new IllegalArgumentException("config line too long " + line.length());
        }
        this.sendCommand(String.format("WCONFIG%04X%s", i, line));
    }

    public void clearConfig() throws DriverException {
        this.sendCommand("CLEARCONFIG");
    }

    public void pollOn() throws DriverException {
        this.sendCommand("POLLON");
    }

    public void pollOff() throws DriverException {
        this.sendCommand("POLLOFF");
    }

    public String[] readConfigLines() throws DriverException {
        this.pollOff();
        ArrayList<String> l = new ArrayList<String>(2048);
        int i = 0;
        while (i < 2048) {
            String line = this.readConfigLine(i);
            if (line.equals("")) break;
            l.add(line);
            if (i % 100 == 0) {
                log.info((Object)("reading config : " + i + " ..."), new String[0]);
            }
            ++i;
        }
        log.info((Object)"done reading config", new String[0]);
        this.pollOn();
        return l.toArray(new String[0]);
    }

    @Override
    public void writeConfigLines(String[] lines) throws DriverException {
        this.pollOff();
        this.clearConfig();
        int i = 0;
        while (i < lines.length) {
            this.writeConfigLine(i, lines[i]);
            if (i % 100 == 0) {
                log.info((Object)("writing config : " + i + " ..."), new String[0]);
            }
            ++i;
        }
        this.pollOn();
        log.info((Object)"done writing config", new String[0]);
    }

    @Override
    public void applyAll() throws DriverException {
        this.sendCommand("APPLYALL");
    }

    @Override
    public void powerOn() throws DriverException {
        this.sendCommand("POWERON");
    }

    @Override
    public void powerOff() throws DriverException {
        this.sendCommand("POWERFF");
    }

    public void loadTiming() throws DriverException {
        this.sendCommand("LOADTIMING");
    }

    public void loadParams() throws DriverException {
        this.sendCommand("LOADPARAMS");
    }

    public void loadParam(String p) throws DriverException {
        this.sendCommand("LOADPARAM " + p);
    }

    public void resetTiming() throws DriverException {
        this.sendCommand("RESETTIMING");
    }

    public void applyMod(int module) throws DriverException {
        this.sendCommand(String.format("APPLYMOD%02X", module));
    }

    public RawImageData fetchLastImage() throws DriverException {
        FrameStatus fs = this.getFrameStatus();
        int newestFrame = this.lastFrame;
        int newestBuf = -1;
        int i = 0;
        while (i < 3) {
            if (fs.bufFrame[i] > newestFrame && fs.bufComplete[i] != 0) {
                newestFrame = fs.bufFrame[i];
                newestBuf = i;
            }
            ++i;
        }
        if (newestBuf < 0) {
            return null;
        }
        this.lock(newestBuf + 1);
        return this.fetchCurrentLockedFrame();
    }

    @Override
    public RawImageData fetchNewImage(long timeout) throws DriverException, TimeoutException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            RawImageData data = this.fetchLastImage();
            if (data != null) {
                return data;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new TimeoutException("timeout waiting for new image");
    }

    public RawImageData fetchCurrentLockedFrame() throws DriverException {
        FrameStatus fs = this.getFrameStatus();
        int buf = fs.rBuf - 1;
        if (buf < 0 || buf > 2) {
            log.error((Object)("invalid RBUF " + buf), new String[0]);
            return null;
        }
        log.info((Object)("reading buffer " + buf + " frame " + fs.bufFrame[buf]), new String[0]);
        int w = fs.bufWidth[buf];
        int h = fs.bufHeight[buf];
        int mode = fs.bufSample[buf];
        int sz = mode == 1 ? 4 * w * h : 2 * w * h;
        byte[] data = new byte[sz];
        this.fetch(buf + 5 << 29, data);
        this.lastFrame = fs.bufFrame[buf];
        RawImageData imData = new RawImageData();
        imData.width = w;
        imData.height = h;
        imData.mode = RawImageData.Mode.values()[mode];
        imData.data = data;
        return imData;
    }

    public static String[] getConfigFromACF(BufferedReader rdr) throws IOException {
        String line;
        ArrayList<String> l = new ArrayList<String>(1024);
        boolean inConfig = false;
        while ((line = rdr.readLine()) != null) {
            if (line.startsWith("[CONFIG]")) {
                inConfig = true;
                continue;
            }
            if (!inConfig) continue;
            line = line.replaceAll("\"", "");
            line = line.replaceAll("\\\\", "/");
            System.out.println(line);
            l.add(line);
        }
        log.info((Object)("read " + l.size() + " config lines"), new String[0]);
        return l.toArray(new String[0]);
    }

    public static void main(String[] args) throws DriverException, IOException {
        ArchonControllerDriver ctl;
        Locale.setDefault(Locale.US);
        try {
            ctl = new ArchonControllerDriver("127.0.0.1");
        }
        catch (DriverException driverException) {
            ctl = new ArchonControllerDriver("10.0.0.2");
        }
        System.out.println("\n\n**** CONFIGURATION\n");
        ctl.config.dump();
        System.out.println("\n\n**** STATUS\n");
        ctl.status.dump();
        FrameStatus f = ctl.getFrameStatus();
        System.out.printf("\n\nTimer: %x\nread buffer: %d\nwrite buffer: %d\n", f.timer, f.rBuf, f.wBuf);
        System.out.println("\n\n**** TEST READING TWO 1024-BYTE BLOCKS\n");
        byte[] data = ctl.sendBinCommand("FETCH2000000000000002", 2);
        System.out.println(data.length);
        data = ctl.fetch(0x20000000, 2);
        System.out.println(data.length);
        System.out.println();
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)"archon.acf");
        if (is != null) {
            log.info((Object)"reading config file", new String[0]);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
            String[] lines = ArchonControllerDriver.getConfigFromACF(rdr);
            ctl.writeConfigLines(lines);
            ctl.applyAll();
            ctl.powerOn();
        }
        System.out.println(ctl.readConfigLine(0));
        FrameStatus fs = ctl.getFrameStatus();
        fs.dump();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (true) {
            fs = ctl.getFrameStatus();
            fs.dump();
            RawImageData img = ctl.fetchLastImage();
            if (img == null) {
                System.out.println("no last image");
            } else {
                System.out.println("last image size " + img.data.length);
                DataOutputStream os = new DataOutputStream(new FileOutputStream("archonimg-" + ctl.lastFrame + ".raw"));
                os.write(img.data, 0, img.data.length);
                os.close();
            }
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static class FrameStatus {
        long timer;
        int rBuf;
        int wBuf;
        int[] bufSample = new int[3];
        int[] bufComplete = new int[3];
        int[] bufMode = new int[3];
        int[] bufFrame = new int[3];
        int[] bufWidth = new int[3];
        int[] bufHeight = new int[3];
        int[] bufPixels = new int[3];
        int[] bufLines = new int[3];
        int[] bufRawBlocks = new int[3];
        int[] bufRawLines = new int[3];
        int[] bufRawOffset = new int[3];
        long[] butTimeStamp = new long[3];

        public void dump() {
            System.out.printf("timer %8X  rbuf %d   wbuf %d\n", this.timer, this.rBuf, this.wBuf);
            int i = 0;
            while (i < 3) {
                System.out.printf("Buffer %d\n", i + 1);
                System.out.printf("  Complete %d  Mode %d  Frame %d  Width %d Height %d\n", this.bufComplete[i], this.bufMode[i], this.bufFrame[i], this.bufWidth[i], this.bufHeight[i]);
                System.out.printf("  Pixels %d  Lines %d \n", this.bufPixels[i], this.bufLines[i]);
                ++i;
            }
        }
    }
}

