package org.lsst.ccs.drivers.archon;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * A dummy ArchonController which can be used for testing the Archon Subsystem
 * when no real archon controller is available. Currently has minimal
 * functionality required by the archon subsystem.
 *
 * @author tonyj
 */
public class DummyArchonController implements ArchonController {

    private static final Logger log = Logger.getLogger("org.lsst.ccs.drivers.archon");

    @Override
    public RawImageData fetchNewImage(long timeout) throws DriverException, TimeoutException {
        return RawImageData.createTestImage();
    }

    @Override
    public ArchonStatus getStatus() throws DriverException {
        return new ArchonStatus();
    }

    @Override
    public void powerOff() throws DriverException {
        log.info("Power Off");
    }

    @Override
    public void powerOn() throws DriverException {
        log.info("Power On");
    }

    @Override
    public void writeConfigLines(String[] lines) throws DriverException {
    }

    @Override
    public void applyAll() throws DriverException {
    }
}
