package org.lsst.ccs.drivers.archon;

import java.util.concurrent.TimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * This is the interface actually used by the ArchonSubsystem. It may
 * need to be extended to include more methods of ArchonController if
 * additional functionality is needed by the subsystem.
 * @author tonyj
 */
public interface ArchonController {

    void applyAll() throws DriverException;

    RawImageData fetchNewImage(long timeout) throws DriverException, TimeoutException;

    ArchonStatus getStatus() throws DriverException;

    void powerOff() throws DriverException;

    void powerOn() throws DriverException;

    void writeConfigLines(String[] lines) throws DriverException;
}
