/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.AllowedValuesProvider;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class RouteSelectionCommandSet
extends CompositeCommandSet
implements AllowedValuesProvider {
    private final CompositeCommandSet parentCommandSet;
    private MethodBasedDictionaryArgument setArg;
    private String selectedRoute = "";
    private final CompositeCommandSet activeRouteCommandSet = new CompositeCommandSet();

    public RouteSelectionCommandSet(CompositeCommandSet parentCommandSet) {
        this.parentCommandSet = parentCommandSet;
        this.add(parentCommandSet);
        CommandSetBuilder builder = new CommandSetBuilder();
        BuiltIns builtIns = new BuiltIns();
        CommandSet builtInCommandSet = builder.buildCommandSet(builtIns);
        this.add(builtInCommandSet);
        for (DictionaryCommand setCommand : builtInCommandSet.getCommandDictionary()) {
            if (setCommand.getArguments().length != 2) continue;
            this.setArg = (MethodBasedDictionaryArgument)setCommand.getArguments()[1];
            this.setArg.setAllowedValuesProvder(this);
            break;
        }
        this.add(this.activeRouteCommandSet);
    }

    private void updateActiveRoute() {
        this.activeRouteCommandSet.clear();
        if (!"".equals(this.selectedRoute)) {
            Map<String, RoutingCommandSet> routesMap = this.getAvailableRoutesMap(this.parentCommandSet);
            for (Map.Entry<String, RoutingCommandSet> entry : routesMap.entrySet()) {
                String routeName = entry.getKey();
                if (routeName.equals(this.selectedRoute)) {
                    CommandSet c = entry.getValue().getRouteCommandSet();
                    this.activeRouteCommandSet.add(c);
                    continue;
                }
                if (!routeName.startsWith(String.valueOf(this.selectedRoute) + "/")) continue;
                String newRoute = routeName.replace(String.valueOf(this.selectedRoute) + "/", "");
                RoutingCommandSet c = new RoutingCommandSet(newRoute, entry.getValue().getRouteCommandSet());
                this.activeRouteCommandSet.add(c);
            }
        }
    }

    void setActiveRoute(String value) {
        if ("".equals(value)) {
            this.selectedRoute = "";
        } else {
            String fullRoute;
            Map<String, RoutingCommandSet> routes = this.getAvailableRoutesMap(this.parentCommandSet);
            String string = fullRoute = !routes.containsKey(value) && !"".equals(this.selectedRoute) ? String.valueOf(this.selectedRoute) + "/" + value : value;
            if (!routes.containsKey(fullRoute)) {
                throw new RuntimeException("Error: could not find route " + value + " to activate.");
            }
            this.selectedRoute = fullRoute;
        }
        this.updateActiveRoute();
    }

    String getActiveRoute() {
        return this.selectedRoute;
    }

    @Override
    public List<String> getAllowedValues() {
        this.updateActiveRoute();
        ArrayList<String> allowedValues = new ArrayList<String>(this.getAvailableRoutesMap(this.parentCommandSet).keySet());
        for (CommandSet cs : this.activeRouteCommandSet.getCommandSets()) {
            if (!(cs instanceof RoutingCommandSet)) continue;
            allowedValues.add(((RoutingCommandSet)cs).getRoute());
        }
        return allowedValues;
    }

    private Map<String, RoutingCommandSet> getAvailableRoutesMap(CommandSet cs) {
        LinkedHashMap<String, RoutingCommandSet> result = new LinkedHashMap<String, RoutingCommandSet>();
        if (cs instanceof RoutingCommandSet) {
            String fullRoute = ((RoutingCommandSet)cs).getRoute();
            result.put(fullRoute, (RoutingCommandSet)cs);
        }
        if (cs instanceof CompositeCommandSet) {
            for (CommandSet s : ((CompositeCommandSet)cs).getCommandSets()) {
                result.putAll(this.getAvailableRoutesMap(s));
            }
        }
        return result;
    }

    public class BuiltIns {
        @Command(description="Modify various settings")
        public void set(@Argument(name="item") SetGetCommands what, @Argument(name="value", defaultValue="") String value) {
            switch (what) {
                case ROUTE: {
                    RouteSelectionCommandSet.this.setActiveRoute(value);
                }
            }
        }

        @Command(description="Get various settings")
        public String get(@Argument(name="item") SetGetCommands what) {
            switch (what) {
                case ROUTE: {
                    return RouteSelectionCommandSet.this.getActiveRoute();
                }
            }
            return null;
        }
    }

    public static enum SetGetCommands {
        ROUTE;

    }
}

