/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.archon;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class RawImageData {
    public int width;
    public int height;
    public Mode mode;
    public byte[] data;

    public static RawImageData createTestImage() {
        RawImageData testData = new RawImageData();
        testData.mode = Mode.BIT16;
        testData.height = 4096;
        testData.width = 4352;
        testData.data = new byte[testData.width * testData.height * 2];
        ByteBuffer bb = ByteBuffer.wrap(testData.data);
        ShortBuffer sb = bb.asShortBuffer();
        int j = 0;
        while (j < testData.height) {
            int i = 0;
            while (i < testData.width) {
                sb.put((short)(RawImageData.isOverScan(i, j) ? 50 : 100 + 2 * i + 3 * j));
                ++i;
            }
            ++j;
        }
        return testData;
    }

    private static boolean isOverScan(int i, int j) {
        return (i %= 544) < 10 || i >= 522 || (j %= 2048) >= 2002;
    }

    public static enum Mode {
        BIT16(2),
        BIT32(4);

        private final int bytes;

        private Mode(int bytes) {
            this.bytes = bytes;
        }

        public int bytes() {
            return this.bytes;
        }

        public int bits() {
            return 8 * this.bytes;
        }
    }
}

