/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class AP9630UPS
extends Session {
    public static final int ST_ONLINE = 0;
    public static final int ST_BATTERY = 1;
    public static final int ST_OFFLINE = 2;
    private static final int DEFAULT_BAUDRATE = 9600;
    private static final int LOG_TIMEOUT = 500;
    private static final int RUN_TIMEOUT = 50;
    private String product;
    private String fwVersion;

    public AP9630UPS() {
        super(1, "apc>", "User Name :", "Password  :", Ascii.Terminator.CR);
    }

    public void open(Session.ConnType connType, String ident, String username, String password) throws DriverException {
        this.open(connType, ident, 9600, username, password, 500, 50);
    }

    public void open(Session.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 9600, 50);
    }

    public void close() throws DriverException {
        try {
            super.close();
        }
        finally {
            this.product = null;
            this.fwVersion = null;
        }
    }

    public String getProductName() throws DriverException {
        if (this.product == null) {
            this.getVersionInfo();
        }
        return this.product;
    }

    public String getFWVersion() throws DriverException {
        if (this.fwVersion == null) {
            this.getVersionInfo();
        }
        return this.fwVersion;
    }

    public int getStatus() throws DriverException {
        String[] reply = this.receiveString("detstatus -ss");
        AP9630UPS.checkReplyLength((String[])reply, (int)6);
        String[] words = this.getStringValue(reply[0]).split(" ");
        return words[0].equals("Online") ? 0 : 1;
    }

    public double getOutputVoltage() throws DriverException {
        String[] reply = this.receiveString("detstatus -om");
        AP9630UPS.checkReplyLength((String[])reply, (int)9);
        return AP9630UPS.getDoubleValue(reply[0]);
    }

    public double getOutputCurrent() throws DriverException {
        String[] reply = this.receiveString("detstatus -om");
        AP9630UPS.checkReplyLength((String[])reply, (int)9);
        return AP9630UPS.getDoubleValue(reply[4]);
    }

    public double getOutputPower() throws DriverException {
        String[] reply = this.receiveString("detstatus -om");
        AP9630UPS.checkReplyLength((String[])reply, (int)9);
        return AP9630UPS.getDoubleValue(reply[2]);
    }

    public double getTemperature() throws DriverException {
        String[] reply = this.receiveString("detstatus -tmp");
        AP9630UPS.checkReplyLength((String[])reply, (int)3);
        return AP9630UPS.getDoubleValue(reply[0]);
    }

    public double getBatteryVoltage() throws DriverException {
        String[] reply = this.receiveString("detstatus -bat");
        AP9630UPS.checkReplyLength((String[])reply, (int)3);
        return AP9630UPS.getDoubleValue(reply[0]);
    }

    public double getBatteryCharge() throws DriverException {
        String[] reply = this.receiveString("detstatus -soc");
        AP9630UPS.checkReplyLength((String[])reply, (int)3);
        return AP9630UPS.getDoubleValue(reply[0]);
    }

    public int getRunTime() throws DriverException {
        String[] reply = this.receiveString("detstatus -rt");
        AP9630UPS.checkReplyLength((String[])reply, (int)3);
        String[] words = this.getStringValue(reply[0]).split(" ");
        try {
            return Integer.parseInt(words[4]) + 60 * Integer.parseInt(words[2]) + 3600 * Integer.parseInt(words[0]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            AP9630UPS.responseError((String)reply[0]);
            return 0;
        }
    }

    public synchronized String[] receiveString(String command) throws DriverException {
        String[] resp = this.receive(command);
        if (resp.length < 2) {
            throw new DriverException("No response received");
        }
        if (resp[1].matches("E\\d\\d\\d:.*")) {
            if (resp[1].startsWith("E00")) {
                String[] reply = new String[resp.length - 2];
                System.arraycopy(resp, 2, reply, 0, reply.length);
                return reply;
            }
            throw new DriverException("Command error: " + resp[1]);
        }
        throw new DriverException("Unexpected response: " + resp[1]);
    }

    private void getVersionInfo() throws DriverException {
        String[] reply = this.receiveString("upsabout");
        AP9630UPS.checkReplyLength((String[])reply, (int)11);
        this.product = this.getStringValue(reply[0]);
        this.fwVersion = this.getStringValue(reply[2]);
    }

    private String getStringValue(String line) throws DriverException {
        try {
            return line.split(": ")[1];
        }
        catch (IndexOutOfBoundsException e) {
            AP9630UPS.responseError((String)line);
            return null;
        }
    }

    private static double getDoubleValue(String line) throws DriverException {
        try {
            return Double.parseDouble(line.split(": ")[1].split(" ")[0]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            AP9630UPS.responseError((String)line);
            return 0.0;
        }
    }
}

