/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class APC7900
extends Session {
    private static final int DEFAULT_BAUDRATE = 9600;
    private static final int LOG_TIMEOUT = 200;
    private static final int RUN_TIMEOUT = 50;
    private static final String STATUS_SPLIT_RE = " *: ";
    private String product;
    private String fwVersion;
    private Integer numPhases;
    private Integer numOutlets;

    public APC7900() {
        super(1, "APC>", "User Name :", "Password  :", Ascii.Terminator.CR);
    }

    public void open(Session.ConnType connType, String ident, String username, String password) throws DriverException {
        this.open(connType, ident, 9600, username, password + " -c", 200, 50);
    }

    public void open(Session.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 9600, 50);
    }

    @Override
    public void close() throws DriverException {
        try {
            super.close();
        }
        finally {
            this.product = null;
            this.fwVersion = null;
            this.numPhases = null;
            this.numOutlets = null;
        }
    }

    public String getProductName() throws DriverException {
        if (this.product == null) {
            this.getVersionInfo();
        }
        return this.product;
    }

    public String getFWVersion() throws DriverException {
        if (this.fwVersion == null) {
            this.getVersionInfo();
        }
        return this.fwVersion;
    }

    public int getPhaseCount() throws DriverException {
        if (this.numPhases == null) {
            this.getVersionInfo();
        }
        return this.numPhases;
    }

    public int getOutletCount() throws DriverException {
        if (this.numOutlets == null) {
            this.getVersionInfo();
        }
        return this.numOutlets;
    }

    public String getOutletName(int outlet) throws DriverException {
        String[] reply = this.receiveString("status " + outlet);
        APC7900.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[2];
    }

    public void setOutletName(int outlet, String name) throws DriverException {
        String[] reply = this.receiveString("name " + outlet + " \"" + name + "\"");
    }

    public int getOutletNumber(String outlet) throws DriverException {
        String[] reply = this.receiveString("status \"" + outlet + "\"");
        APC7900.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        int number = 0;
        try {
            number = Integer.valueOf(words[0]);
        }
        catch (NumberFormatException e) {
            APC7900.responseError(reply[0]);
        }
        return number;
    }

    public Map<String, Integer> getOutletNumberMap() throws DriverException {
        String[] reply = this.receiveString("status");
        APC7900.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Integer> numberMap = new LinkedHashMap<String, Integer>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            try {
                numberMap.put(words.length >= 3 ? words[2] : "", Integer.valueOf(words[0]));
            }
            catch (NumberFormatException e) {
                APC7900.responseError(line);
            }
        }
        return numberMap;
    }

    public int getOutletOnDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("powerondelay " + outlet));
    }

    public int getOutletOffDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("poweroffdelay " + outlet));
    }

    public int getOutletOnDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("powerondelay \"" + outlet + "\""));
    }

    public int getOutletOffDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("poweroffdelay \"" + outlet + "\""));
    }

    private int extractDelay(String[] reply) throws DriverException {
        APC7900.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        String[] values = words[2].split(" ");
        int delay = 0;
        try {
            delay = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            APC7900.responseError(reply[0]);
        }
        return delay;
    }

    public int[] getOutletOnDelays() throws DriverException {
        return this.getOutletDelays(true);
    }

    public int[] getOutletOffDelays() throws DriverException {
        return this.getOutletDelays(false);
    }

    private int[] getOutletDelays(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "powerondelay" : "poweroffdelay");
        APC7900.checkReplyLength(reply, this.getOutletCount());
        int[] delays = new int[reply.length];
        for (int j = 0; j < reply.length; ++j) {
            String[] words = reply[j].split(STATUS_SPLIT_RE);
            String[] values = words[2].split(" ");
            try {
                delays[j] = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900.responseError(reply[j]);
            }
        }
        return delays;
    }

    public Map<String, Integer> getOutletOnDelayMap() throws DriverException {
        return this.getOutletDelayMap(true);
    }

    public Map<String, Integer> getOutletOffDelayMap() throws DriverException {
        return this.getOutletDelayMap(false);
    }

    private Map<String, Integer> getOutletDelayMap(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "powerondelay" : "poweroffdelay");
        APC7900.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Integer> delayMap = new LinkedHashMap<String, Integer>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            String[] values = words[2].split(" ");
            int delay = 0;
            try {
                delay = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900.responseError(line);
            }
            delayMap.put(words[1], delay);
        }
        return delayMap;
    }

    public void setOutletOnDelay(int delay, int outlet) throws DriverException {
        this.receiveString("powerondelay " + outlet + ":" + delay);
    }

    public void setOutletOffDelay(int delay, int outlet) throws DriverException {
        this.receiveString("poweroffdelay " + outlet + ":" + delay);
    }

    public void setOutletOnDelay(int delay, String outlet) throws DriverException {
        this.receiveString("powerondelay \"" + outlet + "\":" + delay);
    }

    public void setOutletOffDelay(int delay, String outlet) throws DriverException {
        this.receiveString("poweroffdelay \"" + outlet + "\":" + delay);
    }

    public void setOutletOnDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("powerondelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOffDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("poweroffdelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOnDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("powerondelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOffDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("poweroffdelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public boolean isOutletOn(int outlet) throws DriverException {
        String[] reply = this.receiveString("status " + outlet);
        APC7900.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[1].equals("ON");
    }

    public boolean isOutletOn(String outlet) throws DriverException {
        String[] reply = this.receiveString("status \"" + outlet + "\"");
        APC7900.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[1].equals("ON");
    }

    public boolean[] getOutletOnStates() throws DriverException {
        String[] reply = this.receiveString("status");
        boolean[] onStates = new boolean[this.getOutletCount()];
        APC7900.checkReplyLength(reply, onStates.length);
        for (int j = 0; j < onStates.length; ++j) {
            String[] words = reply[j].split(STATUS_SPLIT_RE);
            onStates[j] = words[1].equals("ON");
        }
        return onStates;
    }

    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        String[] reply = this.receiveString("status");
        APC7900.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Boolean> stateMap = new LinkedHashMap<String, Boolean>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            stateMap.put(words.length >= 3 ? words[2] : "", words[1].equals("ON"));
        }
        return stateMap;
    }

    public int setOutletOn(int outlet) throws DriverException {
        return this.receiveString("on " + outlet).length;
    }

    public int setOutletOff(int outlet) throws DriverException {
        return this.receiveString("off " + outlet).length;
    }

    public int setOutletOn(String outlet) throws DriverException {
        return this.receiveString("on \"" + outlet + "\"").length;
    }

    public int setOutletOff(String outlet) throws DriverException {
        return this.receiveString("off \"" + outlet + "\"").length;
    }

    public int setOutletsOn(int[] outlets) throws DriverException {
        return this.receiveString("on" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOff(int[] outlets) throws DriverException {
        return this.receiveString("off" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOn(String[] outlets) throws DriverException {
        return this.receiveString("on" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOff(String[] outlets) throws DriverException {
        return this.receiveString("off" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletOn(int outlet) throws DriverException {
        return this.receiveString("delayedon " + outlet).length;
    }

    public int delayedOutletOff(int outlet) throws DriverException {
        return this.receiveString("delayedoff " + outlet).length;
    }

    public int delayedOutletOn(String outlet) throws DriverException {
        return this.receiveString("delayedon \"" + outlet + "\"").length;
    }

    public int delayedOutletOff(String outlet) throws DriverException {
        return this.receiveString("delayedoff \"" + outlet + "\"").length;
    }

    public int delayedOutletsOn(int[] outlets) throws DriverException {
        return this.receiveString("delayedon" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOff(int[] outlets) throws DriverException {
        return this.receiveString("delayedoff" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOn(String[] outlets) throws DriverException {
        return this.receiveString("delayedon" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOff(String[] outlets) throws DriverException {
        return this.receiveString("delayedoff" + this.makeOutletString(outlets)).length;
    }

    public double[] readCurrent() throws DriverException {
        String[] reply = this.receiveString("current");
        APC7900.checkReplyLength(reply, this.getPhaseCount());
        double[] current = new double[reply.length];
        for (int j = 0; j < current.length; ++j) {
            try {
                String token = reply[j].split(": ")[1];
                current[j] = Double.valueOf(token.substring(0, token.length() - 1));
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900.responseError(reply[j]);
            }
        }
        return current;
    }

    public double readVA() throws DriverException {
        return this.readPowers()[0];
    }

    public double readPower() throws DriverException {
        return this.readPowers()[1];
    }

    public double[] readPowers() throws DriverException {
        String[] reply = this.receiveString("power");
        APC7900.checkReplyLength(reply, 2);
        double[] values = new double[2];
        for (int j = 0; j < 2; ++j) {
            try {
                values[j] = Double.valueOf(reply[j].split(" ")[0]);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900.responseError(reply[j]);
            }
        }
        return values;
    }

    public synchronized String[] receiveString(String command) throws DriverException {
        String[] resp = this.receive(command);
        if (resp.length < 2) {
            throw new DriverException("No response received");
        }
        if (!resp[1].equals(" OK")) {
            throw new DriverException("Command error" + resp[1]);
        }
        if (resp.length == 3) {
            int posn;
            int n = resp[2].startsWith(" E1") ? 1 : (posn = resp[2].startsWith("E1") ? 0 : -1);
            if (posn >= 0) {
                throw new DriverException("Command error " + resp[2].substring(posn));
            }
        }
        String[] reply = new String[resp.length - 2];
        for (int j = 0; j < reply.length; ++j) {
            reply[j] = resp[j + 2].substring(1);
        }
        return reply;
    }

    private void getVersionInfo() throws DriverException {
        String[] reply = this.receiveString("ver");
        APC7900.checkReplyLength(reply, 6);
        this.fwVersion = reply[0];
        this.product = reply[2].split(": ")[1];
        try {
            this.numOutlets = Integer.decode(reply[3].split(": ")[1]);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid outlets line: " + reply[3]);
        }
        String inpType = reply[5].split(": ")[1];
        this.numPhases = inpType.equals("Single") ? 1 : 3;
    }

    private String makeOutletString(int[] outlets) {
        StringBuilder outString = new StringBuilder();
        int sep = 32;
        for (int outlet : outlets) {
            outString = outString.append((char)sep).append(outlet);
            sep = 44;
        }
        return outString.toString();
    }

    private String makeOutletString(String[] outlets) {
        StringBuilder outString = new StringBuilder();
        int sep = 32;
        for (String outlet : outlets) {
            outString = outString.append((char)sep).append('\"').append(outlet).append('\"');
            sep = 44;
        }
        return outString.toString();
    }
}

