/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.net.telnet.TelnetClient;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class APC7900 {
    private static final int DEFAULT_BAUDRATE = 9600;
    private static final int TELNET_PORT = 23;
    private static final int SOCKET_TIMEOUT = 20;
    private static final int POLL_PERIOD = 10;
    private static final int INITIAL_TIMEOUT = 2000;
    private static final int FINAL_TIMEOUT = 50;
    private static final String STATUS_SPLIT_RE = " *: ";
    private final Ascii asc = new Ascii(Ascii.Option.NO_NET);
    private final TelnetClient tc = new TelnetClient();
    private boolean isTelnet;
    private InputStream in;
    private OutputStream out;
    private String prompt = "";
    private String product;
    private String fwVersion;
    private Integer numPhases;
    private Integer numOutlets;

    public void open(ConnType connType, String ident, String username, String password) throws DriverException {
        this.open(connType, ident);
        try {
            if (this.isTelnet) {
                this.receive();
            } else {
                this.receive("");
                if (this.prompt.isEmpty()) {
                    this.receive("");
                }
                if (this.prompt.contains("APC>")) {
                    return;
                }
            }
            if (!this.prompt.contains("User Name :")) {
                throw new DriverException("Unrecognized login prompt: " + this.prompt);
            }
            this.receive(username);
            if (!this.prompt.contains("Password  :")) {
                throw new DriverException("Unrecognized password prompt: " + this.prompt);
            }
            String[] resp = this.receive(password + " -c");
            if (resp.length == 0) {
                throw new DriverException("Login failed");
            }
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public void open(ConnType connType, String ident) throws DriverException {
        Ascii.ConnType cType = connType.getValue();
        if (cType != null) {
            this.isTelnet = false;
            this.asc.open(cType, ident, 9600);
            this.asc.setTerminator("\r");
        } else {
            this.isTelnet = true;
            if (this.in != null) {
                throw new DriverException("Connection already open");
            }
            try {
                this.tc.connect(ident, 23);
                this.tc.setSoTimeout(20);
                this.in = this.tc.getInputStream();
                this.out = this.tc.getOutputStream();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        }
    }

    public void close() throws DriverException {
        this.checkOpen();
        if (!this.isTelnet) {
            try {
                this.send("quit");
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        try {
            if (this.isTelnet) {
                this.tc.disconnect();
            } else {
                this.asc.close();
            }
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
        finally {
            this.prompt = "";
            this.in = null;
            this.out = null;
            this.product = null;
            this.fwVersion = null;
            this.numPhases = null;
            this.numOutlets = null;
            this.isTelnet = false;
        }
    }

    public String getProductName() throws DriverException {
        if (this.product == null) {
            this.getVersionInfo();
        }
        return this.product;
    }

    public String getFWVersion() throws DriverException {
        if (this.fwVersion == null) {
            this.getVersionInfo();
        }
        return this.fwVersion;
    }

    public int getPhaseCount() throws DriverException {
        if (this.numPhases == null) {
            this.getVersionInfo();
        }
        return this.numPhases;
    }

    public int getOutletCount() throws DriverException {
        if (this.numOutlets == null) {
            this.getVersionInfo();
        }
        return this.numOutlets;
    }

    public String getOutletName(int outlet) throws DriverException {
        String[] reply = this.receiveString("status " + outlet);
        this.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[2];
    }

    public void setOutletName(int outlet, String name) throws DriverException {
        String[] reply = this.receiveString("name " + outlet + " " + name);
    }

    public int getOutletNumber(String outlet) throws DriverException {
        String[] reply = this.receiveString("status \"" + outlet + "\"");
        this.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        int number = 0;
        try {
            number = Integer.valueOf(words[0]);
        }
        catch (NumberFormatException e) {
            this.responseError(reply[0]);
        }
        return number;
    }

    public Map<String, Integer> getOutletNumberMap() throws DriverException {
        String[] reply = this.receiveString("status");
        this.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Integer> numberMap = new LinkedHashMap<String, Integer>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            try {
                numberMap.put(words[2], Integer.valueOf(words[0]));
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.responseError(reply[0]);
            }
        }
        return numberMap;
    }

    public int getOutletOnDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("powerondelay " + outlet));
    }

    public int getOutletOffDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("poweroffdelay " + outlet));
    }

    public int getOutletOnDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("powerondelay \"" + outlet + "\""));
    }

    public int getOutletOffDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("poweroffdelay \"" + outlet + "\""));
    }

    private int extractDelay(String[] reply) throws DriverException {
        this.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        String[] values = words[2].split(" ");
        int delay = 0;
        try {
            delay = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            this.responseError(reply[0]);
        }
        return delay;
    }

    public int[] getOutletOnDelays() throws DriverException {
        return this.getOutletDelays(true);
    }

    public int[] getOutletOffDelays() throws DriverException {
        return this.getOutletDelays(false);
    }

    private int[] getOutletDelays(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "powerondelay" : "poweroffdelay");
        this.checkReplyLength(reply, this.getOutletCount());
        int[] delays = new int[reply.length];
        for (int j = 0; j < reply.length; ++j) {
            String[] words = reply[j].split(STATUS_SPLIT_RE);
            String[] values = words[2].split(" ");
            try {
                delays[j] = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.responseError(reply[j]);
            }
        }
        return delays;
    }

    public Map<String, Integer> getOutletOnDelayMap() throws DriverException {
        return this.getOutletDelayMap(true);
    }

    public Map<String, Integer> getOutletOffDelayMap() throws DriverException {
        return this.getOutletDelayMap(false);
    }

    private Map<String, Integer> getOutletDelayMap(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "powerondelay" : "poweroffdelay");
        this.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Integer> delayMap = new LinkedHashMap<String, Integer>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            String[] values = words[2].split(" ");
            int delay = 0;
            try {
                delay = values[4].equals("never.") ? -1 : Integer.valueOf(values[4]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.responseError(line);
            }
            delayMap.put(words[1], delay);
        }
        return delayMap;
    }

    public void setOutletOnDelay(int delay, int outlet) throws DriverException {
        this.receiveString("powerondelay " + outlet + ":" + delay);
    }

    public void setOutletOffDelay(int delay, int outlet) throws DriverException {
        this.receiveString("poweroffdelay " + outlet + ":" + delay);
    }

    public void setOutletOnDelay(int delay, String outlet) throws DriverException {
        this.receiveString("powerondelay \"" + outlet + "\":" + delay);
    }

    public void setOutletOffDelay(int delay, String outlet) throws DriverException {
        this.receiveString("poweroffdelay \"" + outlet + "\":" + delay);
    }

    public void setOutletOnDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("powerondelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOffDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("poweroffdelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOnDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("powerondelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public void setOutletOffDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("poweroffdelay " + this.makeOutletString(outlets) + ":" + delay);
    }

    public boolean isOutletOn(int outlet) throws DriverException {
        String[] reply = this.receiveString("status " + outlet);
        this.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[1].equals("ON");
    }

    public boolean isOutletOn(String outlet) throws DriverException {
        String[] reply = this.receiveString("status \"" + outlet + "\"");
        this.checkReplyLength(reply, 1);
        String[] words = reply[0].split(STATUS_SPLIT_RE);
        return words[1].equals("ON");
    }

    public boolean[] getOutletOnStates() throws DriverException {
        String[] reply = this.receiveString("status");
        boolean[] onStates = new boolean[this.getOutletCount()];
        this.checkReplyLength(reply, onStates.length);
        for (int j = 0; j < onStates.length; ++j) {
            String[] words = reply[j].split(STATUS_SPLIT_RE);
            onStates[j] = words[1].equals("ON");
        }
        return onStates;
    }

    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        String[] reply = this.receiveString("status");
        this.checkReplyLength(reply, this.getOutletCount());
        LinkedHashMap<String, Boolean> stateMap = new LinkedHashMap<String, Boolean>();
        for (String line : reply) {
            String[] words = line.split(STATUS_SPLIT_RE);
            stateMap.put(words[2], words[1].equals("ON"));
        }
        return stateMap;
    }

    public int setOutletOn(int outlet) throws DriverException {
        return this.receiveString("on " + outlet).length;
    }

    public int setOutletOff(int outlet) throws DriverException {
        return this.receiveString("off " + outlet).length;
    }

    public int setOutletOn(String outlet) throws DriverException {
        return this.receiveString("on \"" + outlet + "\"").length;
    }

    public int setOutletOff(String outlet) throws DriverException {
        return this.receiveString("off \"" + outlet + "\"").length;
    }

    public int setOutletsOn(int[] outlets) throws DriverException {
        return this.receiveString("on" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOff(int[] outlets) throws DriverException {
        return this.receiveString("off" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOn(String[] outlets) throws DriverException {
        return this.receiveString("on" + this.makeOutletString(outlets)).length;
    }

    public int setOutletsOff(String[] outlets) throws DriverException {
        return this.receiveString("off" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletOn(int outlet) throws DriverException {
        return this.receiveString("delayedon " + outlet).length;
    }

    public int delayedOutletOff(int outlet) throws DriverException {
        return this.receiveString("delayedoff " + outlet).length;
    }

    public int delayedOutletOn(String outlet) throws DriverException {
        return this.receiveString("delayedon \"" + outlet + "\"").length;
    }

    public int delayedOutletOff(String outlet) throws DriverException {
        return this.receiveString("delayedoff \"" + outlet + "\"").length;
    }

    public int delayedOutletsOn(int[] outlets) throws DriverException {
        return this.receiveString("delayedon" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOff(int[] outlets) throws DriverException {
        return this.receiveString("delayedoff" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOn(String[] outlets) throws DriverException {
        return this.receiveString("delayedon" + this.makeOutletString(outlets)).length;
    }

    public int delayedOutletsOff(String[] outlets) throws DriverException {
        return this.receiveString("delayedoff" + this.makeOutletString(outlets)).length;
    }

    public double[] readCurrent() throws DriverException {
        String[] reply = this.receiveString("current");
        this.checkReplyLength(reply, this.getPhaseCount());
        double[] current = new double[reply.length];
        for (int j = 0; j < current.length; ++j) {
            try {
                String token = reply[j].split(": ")[1];
                current[j] = Double.valueOf(token.substring(0, token.length() - 1));
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.responseError(reply[j]);
            }
        }
        return current;
    }

    public double readVA() throws DriverException {
        return this.readPowers()[0];
    }

    public double readPower() throws DriverException {
        return this.readPowers()[1];
    }

    public double[] readPowers() throws DriverException {
        String[] reply = this.receiveString("power");
        this.checkReplyLength(reply, 2);
        double[] values = new double[2];
        for (int j = 0; j < 2; ++j) {
            try {
                values[j] = Double.valueOf(reply[j].split(" ")[0]);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                this.responseError(reply[j]);
            }
        }
        return values;
    }

    public synchronized String[] receiveString(String command) throws DriverException {
        String[] resp = this.receive(command);
        if (resp.length < 2) {
            throw new DriverException("No response received");
        }
        if (!resp[1].equals(" OK")) {
            throw new DriverException("Command error" + resp[1]);
        }
        if (resp.length == 3) {
            int posn;
            int n = resp[2].startsWith(" E1") ? 1 : (posn = resp[2].startsWith("E1") ? 0 : -1);
            if (posn >= 0) {
                throw new DriverException("Command error " + resp[2].substring(posn));
            }
        }
        String[] reply = new String[resp.length - 2];
        for (int j = 0; j < reply.length; ++j) {
            reply[j] = resp[j + 2].substring(1);
        }
        return reply;
    }

    public synchronized void send(String command) throws DriverException {
        this.checkOpen();
        if (this.isTelnet) {
            try {
                this.out.write((command + "\r").getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        } else {
            this.asc.write(command);
        }
    }

    public synchronized String[] receive() throws DriverException {
        byte[] buff;
        int offs;
        this.checkOpen();
        ArrayList<byte[]> buffs = new ArrayList<byte[]>();
        int lastLeng = 0;
        int timeout = 2000;
        do {
            int leng;
            buff = new byte[1024];
            for (offs = 0; offs < buff.length; offs += leng) {
                try {
                    leng = this.read(buff, offs, buff.length - offs, timeout);
                }
                catch (DriverTimeoutException e) {
                    if (offs != 0 || !buffs.isEmpty()) break;
                    throw e;
                }
                timeout = 50;
            }
            if (offs <= 0) continue;
            buffs.add(buff);
            lastLeng = offs;
        } while (offs >= buff.length);
        ArrayList<String> resp = new ArrayList<String>();
        String line = "";
        boolean gotCr = false;
        for (int bufNo = 0; bufNo < buffs.size(); ++bufNo) {
            byte[] buff2 = (byte[])buffs.get(bufNo);
            int leng = bufNo == buffs.size() - 1 ? lastLeng : buff2.length;
            int start = 0;
            for (int posn = 0; posn < leng; ++posn) {
                if (buff2[posn] == 13) {
                    if (!gotCr) {
                        line = line + new String(buff2, start, posn - start);
                        resp.add(line);
                        line = "";
                    }
                    start = posn + 1;
                    gotCr = true;
                    continue;
                }
                if (buff2[posn] == 10 && gotCr) {
                    start = posn + 1;
                }
                gotCr = false;
            }
            line = line + new String(buff2, start, leng - start);
        }
        this.prompt = line;
        return resp.toArray(new String[0]);
    }

    public synchronized String[] receive(String command) throws DriverException {
        this.send(command);
        return this.receive();
    }

    public String getPrompt() {
        return this.prompt;
    }

    private void getVersionInfo() throws DriverException {
        String[] reply = this.receiveString("ver");
        this.checkReplyLength(reply, 6);
        this.fwVersion = reply[0];
        this.product = reply[2].split(": ")[1];
        try {
            this.numOutlets = Integer.decode(reply[3].split(": ")[1]);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid outlets line: " + reply[3]);
        }
        String inpType = reply[5].split(": ")[1];
        this.numPhases = inpType.equals("Single") ? 1 : 3;
    }

    private int read(byte[] buff, int offset, int mleng, int timeout) throws DriverException {
        if (this.isTelnet) {
            long endTime = System.currentTimeMillis() + (long)timeout;
            int count = Math.min(mleng, buff.length - offset);
            int leng = 0;
            while (leng == 0 && System.currentTimeMillis() < endTime) {
                try {
                    leng = this.in.read(buff, offset, count);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    throw new DriverException((Throwable)e);
                }
                if (leng < 0) {
                    throw new DriverException("Connection closed remotely");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (leng == 0) {
                throw new DriverTimeoutException("Read timed out");
            }
            return leng;
        }
        this.asc.setTimeout(timeout);
        return this.asc.readBytes(buff, offset, mleng);
    }

    private void checkOpen() throws DriverException {
        if (this.isTelnet && this.in == null) {
            throw new DriverException("Connection not open");
        }
    }

    private String makeOutletString(int[] outlets) {
        StringBuilder outString = new StringBuilder();
        int sep = 32;
        for (int outlet : outlets) {
            outString = outString.append((char)sep).append(outlet);
            sep = 44;
        }
        return outString.toString();
    }

    private String makeOutletString(String[] outlets) {
        StringBuilder outString = new StringBuilder();
        int sep = 32;
        for (String outlet : outlets) {
            outString = outString.append((char)sep).append('\"').append(outlet).append('\"');
            sep = 44;
        }
        return outString.toString();
    }

    private void checkReplyLength(String[] reply, int count) throws DriverException {
        if (reply.length == count) {
            return;
        }
        if (reply.length == 0) {
            throw new DriverException("Missing response");
        }
        throw new DriverException("Incorrect response length: " + reply.length + "; first line = " + reply[0]);
    }

    private void responseError(String resp) throws DriverException {
        throw new DriverException("Incorrect response: " + resp);
    }

    public static enum ConnType {
        TELNET(null),
        FTDI(Ascii.ConnType.FTDI),
        SERIAL(Ascii.ConnType.SERIAL);

        private final Ascii.ConnType connType;

        private ConnType(Ascii.ConnType connType) {
            this.connType = connType;
        }

        Ascii.ConnType getValue() {
            return this.connType;
        }
    }
}

