/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class AP7900
extends Ascii {
    public static double timeout = 30000.0;
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r";
    private byte[] buff = new byte[1024];
    private int buffIn;
    private int buffOut;
    private int major_version;

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.setTimeout(timeout);
    }

    public void openserial(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.open(2, serialname, port);
        this.setTimeout(timeout);
        this.setTerminator(this.terminator);
        System.out.println("Sending returns to get its attention.");
        this.writeAP7900("\u001b");
        this.writeAP7900("\u001b");
        this.writeAP7900("");
        System.out.println("Sending username.");
        this.writeAP7900("apc");
        System.out.println("Sending password.");
        this.writeAP7900("apc");
    }

    public void openftdi(String serialname, int port, int major_version) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.setTerminator(this.terminator);
        this.open(1, serialname, port);
        this.setTimeout(timeout);
        System.out.println("Sending esc to get its attention.");
        this.writeAP7900("\u001b");
        this.writeAP7900("");
        System.out.println("Sending username.");
        this.writeAP7900("apc");
        System.out.println("Sending password.");
        this.writeAP7900("apc");
        System.out.println("Setting AP 7900 major software version to " + major_version);
        this.major_version = major_version;
    }

    public void opennet(String netaddress, int port, int major_version) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.setTerminator(this.terminator);
        this.setTimeout(timeout);
        this.open(0, netaddress, port);
        System.out.println("Sending username.");
        this.writeAP7900("apc");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Sleep was interrupted:" + ex);
        }
        System.out.println("Sending password.");
        this.writeAP7900("apc");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Sleep was interrupted:" + ex);
        }
        System.out.println("Setting AP 7900 major software version to " + major_version);
        this.major_version = major_version;
    }

    @Override
    public void close() throws DriverException {
        super.close();
    }

    public boolean isOutletOn(int chan) throws DriverException {
        String response = null;
        boolean state = false;
        this.writeAP7900("\u001b");
        this.writeAP7900("\u001b");
        this.writeAP7900("\u001b");
        this.writeAP7900("\u001b");
        this.writeAP7900("1");
        if (this.major_version == 2) {
            this.writeAP7900("3");
        } else {
            this.writeAP7900("2");
            this.writeAP7900("1");
        }
        response = this.readAP7900(String.valueOf(chan));
        System.out.println(response);
        if (response.contains("ON")) {
            state = true;
        }
        return state;
    }

    public void setOutletState(int chan, boolean state) throws DriverException {
        Object response = null;
        System.out.println("SetOutletState called for outlet " + chan + " to be set to state " + state);
        this.writeAP7900("\u001b");
        this.writeAP7900("\u001b");
        this.writeAP7900("1");
        if (this.major_version == 2) {
            this.writeAP7900("3");
        } else {
            this.writeAP7900("2");
            this.writeAP7900("1");
        }
        this.writeAP7900(String.valueOf(chan));
        this.writeAP7900("1");
        if (state) {
            this.writeAP7900("1");
        } else {
            this.writeAP7900("2");
        }
        this.writeAP7900("YES");
    }

    public synchronized void writeAP7900(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readAP7900() throws DriverException {
        return this.read();
    }

    public synchronized String readAP7900(String command) throws DriverException {
        this.writeAP7900(command);
        return this.readAP7900();
    }
}

