package org.lsst.ccs.drivers.apcpdu;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ascii.Ascii;
/*
 import org.lsst.ccs.drivers.serial.SerialPort;
 import org.lsst.ccs.drivers.ftdi.Ftdi;
 import org.lsst.ccs.drivers.ftdi.FtdiException;
 */

/**
 **************************************************************************
 **
 ** General access routines for the AP7900 PDU device
 *
 ** @author Homer Neal *
 * **************************************************************************
 */
public class AP7900 extends Ascii {

    public static double timeout = 30000.;
    public static final int DEFAULT_BAUD = 9600;         // APC default baud
    public static final String DEFAULT_DEV = "/dev/ttyS1"; // default serial device

    /**
     **************************************************************************
     **
     ** Public constants *
     * **************************************************************************
     */
    /**
     **************************************************************************
     **
     ** Private constants *
     * **************************************************************************
     */
    private final static byte CR = 0x0d, LF = 0x0a;
    private String terminator = "\r";
    private byte[] buff = new byte[1024];
    private int buffIn, buffOut;

    /**
     **************************************************************************
     **
     ** Constructor * *
     * **************************************************************************
     */
    public AP7900() throws DriverException {
    }

    public void open(String devname, int port) throws DriverException {
        open(Ascii.CONN_TYPE_SERIAL, devname, port);
        setTimeout(timeout); // set SCPI timeout
//        reset();
    }

    /**
     ***************************************************************************
     **
     ** Opens an FTDI connection. *
     * **************************************************************************
     */
    public void openserial(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the PDU");
        open(Ascii.CONN_TYPE_SERIAL, serialname, port);
        setTimeout(timeout); // set SCPI timeout
        setTerminator(terminator);

        // get logged in
        System.out.println("Sending returns to get its attention.");
        writeAP7900("\033");
        writeAP7900("\033");
        writeAP7900("");
//        System.out.println(readAP7900(""));
        System.out.println("Sending username.");
//        System.out.println(readAP7900("apc"));
        writeAP7900("apc");
        System.out.println("Sending password.");
        writeAP7900("apc");
//        reset();
    }

    /**
     ***************************************************************************
     **
     ** Opens an FTDI connection. *
     * **************************************************************************
     */
    public void openftdi(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the PDU");
        setTerminator(terminator);
        open(Ascii.CONN_TYPE_FTDI, serialname, port);
        setTimeout(timeout); // set SCPI timeout

        // get logged in
        System.out.println("Sending esc to get its attention.");
        writeAP7900("\033");
        writeAP7900("");
        System.out.println("Sending username.");
        writeAP7900("apc");
        System.out.println("Sending password.");
        writeAP7900("apc");
//        reset();
    }

    /**
     ***************************************************************************
     **
     ** Opens a Network connection. ssh -L8888:localhost:23 apc@pdu
     * [homer@ts3-2 bin]$ ./CCSbootstrap.sh -app AP7900Test Type help for list
     * of available commands >>>opennet localhost 8888
     *
     * **************************************************************************
     */
    public void opennet(String netaddress, int port) throws DriverException {
        System.out.println("openning connection to the PDU");
        setTerminator(terminator);
        setTimeout(timeout); // set SCPI timeout
        open(Ascii.CONN_TYPE_NETWORK, netaddress, port);

        // get logged in
//         System.out.println("Sending esc to get its attention.");
//         writeAP7900("\033");
//         writeAP7900("");
        System.out.println("Sending username.");
        writeAP7900("apc");
        try {
            Thread.sleep(3000);
        } catch (InterruptedException ex) {
            System.out.println("Sleep was interrupted:"+ex);
        }
        System.out.println("Sending password.");
        writeAP7900("apc");
        try {
            Thread.sleep(3000);
        } catch (InterruptedException ex) {
            System.out.println("Sleep was interrupted:"+ex);
        }
        //        reset();
    }

    /**
     **************************************************************************
     **
     ** Closes the connection. * * @throws DriverException *
     * @throws org.lsst.ccs.drivers.commons.DriverException
     * *************************************************************************
     */
    @Override
    public void close() throws DriverException {
        super.close();
    }

    /**
     ***************************************************************************
     **
     ** Gets the AP7900 channel power state. *
     * @param chan
     * @return 
     * @throws org.lsst.ccs.drivers.commons.DriverException 
     * **************************************************************************
     */
    public boolean isOutletOn(int chan) throws DriverException {
        String response = null;
        boolean state = false;
        /*
         readAP7900("\033"); // main menu
         readAP7900("\033"); // main menu
         readAP7900("\033"); // main menu
         System.out.println(readAP7900("\033")); // main menu
         System.out.println(readAP7900("1")); // device manager
         System.out.println(readAP7900("2")); // outlet management
         System.out.println(readAP7900("1")); // outlet control
         */
        writeAP7900("\033"); // main menu
        writeAP7900("\033"); // main menu
        writeAP7900("\033"); // main menu
        writeAP7900("\033"); // main menu
        writeAP7900("1"); // device manager
        writeAP7900("2"); // outlet management
        writeAP7900("1"); // outlet control
        System.out.println(response = readAP7900(String.valueOf(chan))); // select outlet

        if (response.contains("ON")) {
            state = true;

        }

        return state;
    }

    /**
     ***************************************************************************
     **
     ** Gets the AP7900 channel power state. *
     * **************************************************************************
     */
    public void setOutletState(int chan, boolean state) throws DriverException {
        String response = null;
        System.out.println("SetOutletState called for outlet " + chan + " to be set to state" + state);
        writeAP7900("\033"); // main menu
        writeAP7900("\033"); // main menu
        writeAP7900("1"); // device manager
        writeAP7900("2"); // outlet management
        writeAP7900("1"); // outlet control
        writeAP7900(String.valueOf(chan)); // select outlet
        writeAP7900("1"); // control outlet
        if (state) {
            writeAP7900("1"); // ON
        } else {
            writeAP7900("2");  // OFF
        }
        writeAP7900("YES"); // confirm
/*
        if (response.contains("ON")) {
            System.out.println("Outlet " + chan + " is now ON");
        } else {
            System.out.println("Outlet " + chan + " is now OFF");
        }
        */
    }

    /**
     **************************************************************************
     **
     ** Writes a command.
     *
     ** @param The command to write
     ** @throws DriverException *
     * *************************************************************************
     */
    public synchronized void writeAP7900(String command) throws DriverException {
        write(command);
    }

    /**
     **************************************************************************
     **
     ** Reads a response.
     *
     ** @return The command response string
     ** @throws DriverException
     *
     * *************************************************************************
     */
    public synchronized String readAP7900() throws DriverException {
        return read();
    }

    /**
     **************************************************************************
     **
     ** Reads a response after writing a command. * * @param command The
     * command to write, excluding terminator * * @return The command response
     * string * * @throws DriverException
     *
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
    public synchronized String readAP7900(String command) throws DriverException {
        writeAP7900(command);
        return readAP7900();
    }
}
