package org.lsst.ccs.drivers.apcpdu;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *************************************************************************** 
 ** 
 ** Program to test the AP7900 device driver
 ** 
 ** @author Homer
 ** 
 *************************************************************************** 
 */
public class AP7900Test {

	protected AP7900 mydev;       
        
    @Command(name = "open", description = "Open a device for use")
	public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
                ) throws DriverException {
		
    	    mydev = new AP7900();
			mydev.openftdi(MyDevId,9600);
    }

    @Command(name = "close", description = "Close the device")
	public void close() throws Exception {
    	mydev.close();
	}

    @Command(name = "readamps", description = "Read amps ")
	public void setState(@Argument (name = "setstate", description = "set on/off")
                boolean onOff
                ) throws Exception {
    	mydev.setState(onOff);
	}

}