package org.lsst.ccs.drivers.apcpdu;

import java.util.Random;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ascii.Ascii;
/*
import org.lsst.ccs.drivers.serial.SerialPort;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
*/
/**
 **************************************************************************
 **
 ** General access routines for the AP7900 PDU device 
 ** @author Homer Neal *
 * **************************************************************************
 */
public class AP7900 extends Ascii {

    public static double timeout = 10.; 
    public static final int
        DEFAULT_BAUD     = 9600;         // APC default baud
    public static final String
        DEFAULT_DEV     = "/dev/ttyUSB0"; // default serial device

    
    /**
     **************************************************************************
     **
     ** Public constants *
     * **************************************************************************
     */

    public enum onOff {

        OFF, ON;
    }

    /**
     **************************************************************************
     **
     ** Private constants *
     * **************************************************************************
     */
    private final static byte CR = 0x0d, LF = 0x0a;
    private String terminator = "\r\n";
    private byte[] buff = new byte[1024];
    private int buffIn, buffOut;

//    private SerialPort port = new SerialPort();

    /**
     **************************************************************************
     **
     ** Constructor * *
     * **************************************************************************
     */
    public AP7900() throws DriverException {
    }
    public void open(String devname, int port) throws DriverException
    {
        open(Ascii.CONN_TYPE_SERIAL, devname, port);
        setTimeout(timeout); // set SCPI timeout
//        reset();
    }

   /**
    ***************************************************************************
    **
    **  Opens an FTDI connection.
    **
    ***************************************************************************
    */
    public void openftdi(String serialname, int port) throws DriverException
    {
        System.out.println("openning connection to the PDU");
        open(Ascii.CONN_TYPE_FTDI, serialname, port);
        setTimeout(timeout); // set SCPI timeout
 // get logged in
        System.out.println("Sending CR/LF to get its attention.");
        writeAP7900("");
        System.out.println(readAP7900("exit")); // get into a known state
        writeAP7900("");
        System.out.println("Sending username.");
        writeAP7900("apc");
        System.out.println("Sending password.");
        System.out.println(readAP7900(""));
        writeAP7900("apc");
//        reset();
    }


    /**
     **************************************************************************
     **
     ** Opens a connection. * * @param device The device name of the serial
     * port
     ** @param baud The baud rate
     ** @param dummy Dummy argument * * @throws DriverException *
     * **************************************************************************
     */
/*
    public void open(String device, int baud, int dummy) throws DriverException {
        port.openPort(device);
        port.setParams(baud, 8, 1, 0);
    }
*/
    /**
    ***************************************************************************
    **
    **  Opens an FTDI connection.
    **
    ***************************************************************************
    */
    /*
    public void openftdi(String serialname, int baus) throws DriverException
    {
        try {
            ftdi.open(baud, serialname);
            ftdi.setBaudrate(baud);
        }
        catch (FtdiException e) {
            throw new DriverException(e);
        }
        setTimeout(timeout); // set SCPI timeout
        reset();
    }
*/
    /**
     **************************************************************************
     **
     ** Closes the connection. * * @throws DriverException *
     * *************************************************************************
     */
    public void close() throws DriverException {
//        port.closePort();
    }

    /**
     ***************************************************************************
     **
     ** Turns lamp on or off. *
     * **************************************************************************
     */
    public void setState(boolean on) throws DriverException {
//        writeAP7900("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    /**
     ***************************************************************************
     **
     ** Gets the AP7900 power state. *
     * **************************************************************************
     */
    public boolean getState() throws DriverException {
        return (Integer.decode(readAP7900("STB?")) & (2>>7)) != 0 ;
    }

  /*
    /**
     **************************************************************************
     **
     ** Writes a command. * * @param command The command to write, including
     * the terminator * * @throws DriverException *
     * *************************************************************************
     */
    /*
    public void write(byte[] command) throws DriverException {
        port.writeBytes(command);
    }
*/
    /**
     **************************************************************************
     **
     ** Reads available response data. *
     * @param buff The buffer to receive
     * the response data *
     * @param offset The offset to the first available
     * byte in the buffer * 
     * @return The number of bytes read * * @throws
     * DriverException
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
/*
    public int read(byte[] buff, int offset) throws DriverException {
        return port.read(buff, offset, timeout);
    }
*/
    /**
     **************************************************************************
     **
     ** Flushes any available response data. * * @throws DriverException *
     * *************************************************************************
     */
/*
    public void flush() throws DriverException {
        port.readBytes();
    }
*/
    /**
     **************************************************************************
     **
     ** Sets the receive timeout. * * @param timeout The receive timeout (ms).
     * 0 means no timeout. * * @throws DriverException *
     * *************************************************************************
     */
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    /**
     **************************************************************************
     **
     ** Writes a command. * * @param command The command to write, excluding
     * terminator * * @throws DriverException *
     * *************************************************************************
     */
    public synchronized void writeAP7900(String command) throws DriverException {
//        checkOpen();
//        write((command + terminator).getBytes());
        writeCommand(command);
    }

    /**
     **************************************************************************
     **
     ** Reads a response. * * @return The command response string * * @throws
     * DriverException
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
    public synchronized String readAP7900() throws DriverException {
//        checkOpen();
/*
        try {
            int start = buffOut, end = buffIn, term = -1;
            while (true) {
                for (int j = start; j < end; j++) {
                    if (buff[j] == CR || buff[j] == LF) {
                        if (j == buffOut) {
                            buffOut++;
                        } else {
                            term = j;
                            break;
                        }
                    }
                }
                if (term >= 0) {
                    String resp = new String(buff, buffOut, term - buffOut);
                    buffOut = term + 1;
                    return resp;
                }
                if (buffOut > 0) {
                    System.arraycopy(buff, buffOut, buff, 0, buffIn - buffOut);
                    buffIn -= buffOut;
                    buffOut = 0;
                }
                if (buffIn >= buff.length) {
                    throw new DriverException("Input buffer overflow");
                }
                start = buffIn;
                buffIn += read(buff, buffIn);
                end = buffIn;
            }
        } catch (DriverTimeoutException re) {
            throw re;
        } catch (DriverException re) {
//            closeSilent();
            throw re;
        }
        */
        return null ;
    }

    /**
     **************************************************************************
     **
     ** Reads a response after writing a command. * * @param command The
     * command to write, excluding terminator * * @return The command response
     * string * * @throws DriverException
     ** @throws DriverTimeoutException *
     * *************************************************************************
     */
    public synchronized String readAP7900(String command) throws DriverException {
/*
        flush();
        writeAP7900(command);
        return readAP7900();
*/
        return(readString(command));
    }

   /**
    **************************************************************************
    **
    **  Writes a command
    **
    **  @param  command  The command to write, excluding terminator
    **
    **  @throws  DriverException
    **
    **************************************************************************
    */
//    @Override
    public synchronized void writeCommand(String command) throws DriverException
    {
//        flush();
        write(command);
//        checkError();
    }


   /**
    **************************************************************************
    **
    **  Reads a string after writing a command.
    **
    **  @param  command  The command to write, excluding terminator
    **
    **  @return  The returned string value
    **
    **  @throws  DriverException
    **  @throws  DriverTimeoutException
    **
    **************************************************************************
    */

//    @Override
    public synchronized String readString(String command) throws DriverException
    {
        try {
            return read(command);
        }
        catch (DriverTimeoutException e) {
//            checkError();
            throw e;
        }
    }
}
