/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class AP7900
extends Ascii {
    public static double timeout = 10.0;
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyUSB0";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r\n";
    private byte[] buff = new byte[1024];
    private int buffIn;
    private int buffOut;

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.setTimeout(timeout);
    }

    public void openftdi(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.open(1, serialname, port);
        this.setTimeout(timeout);
        System.out.println("Sending CR/LF to get its attention.");
        this.writeAP7900("");
        System.out.println(this.readAP7900("exit"));
        this.writeAP7900("");
        System.out.println("Sending username.");
        this.writeAP7900("apc");
        System.out.println("Sending password.");
        System.out.println(this.readAP7900(""));
        this.writeAP7900("apc");
    }

    public void close() throws DriverException {
    }

    public void setState(boolean on) throws DriverException {
    }

    public boolean getState() throws DriverException {
        Integer.decode(this.readAP7900("STB?")).intValue();
        return false;
    }

    public void setTimeout(int timeout) throws DriverException {
        AP7900.timeout = timeout;
    }

    public synchronized void writeAP7900(String command) throws DriverException {
        this.writeCommand(command);
    }

    public synchronized String readAP7900() throws DriverException {
        return null;
    }

    public synchronized String readAP7900(String command) throws DriverException {
        return this.readString(command);
    }

    public synchronized void writeCommand(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readString(String command) throws DriverException {
        return this.read(command);
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

