/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

class MethodBasedDictionaryCommand
implements DictionaryCommand {
    private final String description;
    private final String[] aliases;
    private final DictionaryArgument[] params;
    private final Command.CommandType type;
    private final String name;
    private final boolean hasVarArgs;
    private final int level;
    private static final long serialVersionUID = -2134147357955297580L;

    MethodBasedDictionaryCommand(Method annotatedMethod, Command annotation) {
        this.description = annotation.description();
        this.aliases = this.splitAliases(annotation.alias());
        this.type = annotation.type();
        this.name = annotation.name().isEmpty() ? annotatedMethod.getName() : annotation.name();
        this.hasVarArgs = annotatedMethod.isVarArgs();
        this.level = annotation.level();
        Class<?>[] types = annotatedMethod.getParameterTypes();
        Annotation[][] parAnnotations = annotatedMethod.getParameterAnnotations();
        this.params = new MethodBasedDictionaryArgument[types.length];
        Parameter[] methodParameters = annotatedMethod.getParameters();
        int i = 0;
        while (i < types.length) {
            String parName = methodParameters[i].getName();
            String parDescription = "";
            String defaultValue = "***NULL_VALUE_FOR_COMMAND_ARGUMENT***";
            Annotation[] annotationArray = parAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a instanceof Argument) {
                    Argument paramAnnotation = (Argument)a;
                    parName = paramAnnotation.name().isEmpty() ? parName : paramAnnotation.name();
                    parDescription = paramAnnotation.description();
                    if (paramAnnotation.defaultValue().equals("***NULL_VALUE_FOR_COMMAND_ARGUMENT***")) break;
                    defaultValue = paramAnnotation.defaultValue();
                    break;
                }
                ++n2;
            }
            Class<?> parameterType = this.hasVarArgs && i == types.length - 1 ? types[i].getComponentType() : types[i];
            this.params[i] = new MethodBasedDictionaryArgument(parName, parameterType, parDescription, defaultValue);
            ++i;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public DictionaryArgument[] getArguments() {
        return this.params;
    }

    @Override
    public Command.CommandType getType() {
        return this.type;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    @Override
    public boolean isVarArgs() {
        return this.hasVarArgs;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean matchesCommandOrAlias(String value) {
        if (this.name.equals(value)) {
            return true;
        }
        String[] stringArray = this.aliases;
        int n = this.aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (alias.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] splitAliases(String alias) {
        return alias.length() > 0 ? alias.split("\\s?,\\s?") : NO_ALIASES;
    }

    public String toString() {
        return "MethodBasedDictionaryCommand{description='" + this.description + '\'' + ", aliases=" + Arrays.toString(this.aliases) + ", params=" + Arrays.toString(this.params) + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", hasVarArgs=" + this.hasVarArgs + '}';
    }
}

