package org.lsst.ccs.drivers.ametek;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Tests the Ametek AVC cryocooler driver
 *
 *  @author Owen Saxton
 */
public class TestAvcCooler extends TestAscii {

    private final AvcCooler avc;

    public TestAvcCooler() {
        super(new AvcCooler());
        avc = (AvcCooler)dev;
    }

    @Command(description="Show the product type")
    public String product() throws DriverException {
        return avc.getProductType();
    }

    @Command(description="Show the firmware version")
    public String version() throws DriverException {
        return avc.getFWVersion();
    }

    @Command(description="Show the cooler mode")
    public AvcCooler.Mode mode() throws DriverException {
        return avc.getMode();
    }

    @Command(description="Show the target temperature")
    public double target() throws DriverException {
        return avc.getTemperature();
    }

    @Command(description="Show the temperature")
    public double temperature() throws DriverException {
        return avc.readTemperature();
    }

}
