/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.aiousb;

import AIOUSB.AIODeviceInfo;
import AIOUSB.AIOUSB;
import AIOUSB.AIOUSB_BOOL_VAL;
import AIOUSB.DIOBuf;
import AIOUSB.ResultCode;
import java.util.EnumSet;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Interface;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils;
import org.lsst.ccs.drivers.commons.DriverException;

public class USB_DIO_96
implements USB_DIO_96_Interface {
    DIOBuf buffer;

    public void connect() throws DriverException {
        boolean success = false;
        USB_DIO_96_Utils.FCSLOG.info((Object)"Loading AIOUSB64");
        long load_result = AIOUSB.AIOUSB_Init();
        if (load_result != 0L) {
            throw new DriverException("==> Could not load library AIOUSB64");
        }
        USB_DIO_96_Utils.FCSLOG.info((Object)"==> Library AIOUSB64 loaded with success");
        USB_DIO_96_Utils.FCSLOG.info((Object)"Checking AIOUSB devices");
        long check_result = AIOUSB.AIOUSB_ListDevices();
        USB_DIO_96_Utils.FCSLOG.info((Object)("Result code is " + check_result));
        if (0 == ResultCode.AIOUSB_SUCCESS.swigValue()) {
            USB_DIO_96_Utils.FCSLOG.info((Object)ResultCode.AIOUSB_SUCCESS);
            success = true;
        } else if (4 == ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.swigValue()) {
            throw new DriverException(ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.name());
        }
        if (success) {
            this.buffer = new DIOBuf("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            AIODeviceInfo obj = AIOUSB.AIODeviceInfoGet(0L);
            USB_DIO_96_Utils.FCSLOG.info((Object)("device name : " + obj.getName()));
        }
    }

    public long readAllDIO() {
        return AIOUSB.DIO_ReadAllToDIOBuf(0L, this.buffer);
    }

    public void write2AllDIO() {
        AIOUSB.DIO_ConfigureWithDIOBuf(0L, (short)AIOUSB_BOOL_VAL.AIOUSB_FALSE.swigValue(), USB_DIO_96_Utils.OUTPUT_MASK, this.buffer);
    }

    @Override
    public void simulateAutochangerEmpty() {
        USB_DIO_96_Utils.FCSLOG.info((Object)"==>simulateAutochangerEmpty");
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2b, USB_DIO_96_Utils.Loader_Signal.AF0b, USB_DIO_96_Utils.Loader_Signal.LOCKOUT, USB_DIO_96_Utils.Loader_Signal.AF1, USB_DIO_96_Utils.Loader_Signal.AF3, USB_DIO_96_Utils.Loader_Signal.ENG};
        this.setListOfSignals(signalList0, (short)0);
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2, USB_DIO_96_Utils.Loader_Signal.AF0, USB_DIO_96_Utils.Loader_Signal.LOCKOUTb, USB_DIO_96_Utils.Loader_Signal.AF1b, USB_DIO_96_Utils.Loader_Signal.AF3b, USB_DIO_96_Utils.Loader_Signal.ENGb};
        this.setListOfSignals(signalList1, (short)1);
    }

    @Override
    public void simulateAutochangerHoldFilter() {
        USB_DIO_96_Utils.FCSLOG.info((Object)"==>simulateAutochangerHoldFilter");
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2b, USB_DIO_96_Utils.Loader_Signal.AF0, USB_DIO_96_Utils.Loader_Signal.LOCKOUT, USB_DIO_96_Utils.Loader_Signal.AF1, USB_DIO_96_Utils.Loader_Signal.AF3b, USB_DIO_96_Utils.Loader_Signal.ENG};
        this.setListOfSignals(signalList0, (short)0);
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2, USB_DIO_96_Utils.Loader_Signal.AF0b, USB_DIO_96_Utils.Loader_Signal.LOCKOUTb, USB_DIO_96_Utils.Loader_Signal.AF1b, USB_DIO_96_Utils.Loader_Signal.AF3, USB_DIO_96_Utils.Loader_Signal.ENGb};
        this.setListOfSignals(signalList1, (short)1);
    }

    @Override
    public void simulateLockout() {
        USB_DIO_96_Utils.FCSLOG.info((Object)"==>simulateLockout");
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.LOCKOUT};
        this.setListOfSignals(signalList1, (short)1);
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.LOCKOUTb};
        this.setListOfSignals(signalList0, (short)0);
    }

    @Override
    public void simulateNoLockout() {
        USB_DIO_96_Utils.FCSLOG.info((Object)"==>simulateLockout");
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.LOCKOUTb};
        this.setListOfSignals(signalList1, (short)1);
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.LOCKOUT};
        this.setListOfSignals(signalList0, (short)0);
    }

    private void setListOfSignals(USB_DIO_96_Utils.Loader_Signal[] listOfSignals, short valueToSet) {
        for (USB_DIO_96_Utils.Loader_Signal signal : listOfSignals) {
            this.buffer.set(signal.getBuffer_index(), valueToSet);
            this.write2AllDIO();
        }
    }

    public String toString() {
        EnumSet<USB_DIO_96_Utils.Loader_Signal> l_sig = EnumSet.allOf(USB_DIO_96_Utils.Loader_Signal.class);
        StringBuilder sb = new StringBuilder("Loader Signals read on card USB_DIO_96 :\n");
        int i = 1;
        for (USB_DIO_96_Utils.Loader_Signal sig : l_sig) {
            sb.append(sig.name());
            sb.append(" = ");
            sb.append(this.buffer.get(sig.getBuffer_index()));
            String sep = i % 2 == 0 ? "\n" : " ";
            sb.append(sep);
            ++i;
        }
        return sb.toString();
    }
}

