/**
 * This package contains all the tools to connect to a USB_DIO_96 card.
 *
 * Such a card is installed on HCU in standalone bay and it is used when loader is in standalone mode.
 * The goal of this card is to simulate signals coming from autochanger when loader is in standalone mode.
 * This is the case when loader is loading or unloading a filter to or from the stand bench.
 *
 *
 * Installation of drivers for DIO-USB-96 card
 *
 * 1) installation of libusb :
 *
 * yum install libusbx
 * yum install libusbx-devel
 * ==> c’est libusbx-devel qui procure le fichier header libusb.h :
 * /usr/include/libusb-1.0/libusb.h
 *
 * then create a link :
 * ln -s /usr/include/libusb-1.0/libusb.h /usr/include/libusb.h
 * because the installation of the AIOUSB drivers requires /usr/include/libusb.h
 *
 * 2) installation of cmake swig:
 *
 * sudo yum install cmake swig
 *
 * 3) installation of fxload :
 * A helper program to download firmware into FX and FX2 EZ-USB devices
 *
 * git clone https://github.com/accesio/fxload
 *
 * read and follow instructions in REAMD.md
 * copy fxload in your PATH
 *
 * 4) installation of AIOUSB drivers
 *
 * cd
 * git clone https://github.com/accesio/AIOUSB
 *
 * read README.md and build with CMake :
 *
 * cd AIOUSB
 * mkdir build
 * cd build
 * cmake ..
 * make
 * sudo make install
 *
 * ==> does the copy of the AIOUSB firmware in /usr/share/usb and /etc/udev/rules.d
 * 5) copy from gitlab firmware for our card
 * sudo cp USB-DIO-96.hex /usr/share/usb/
 *
 *
 * 6) tester:
 * connecter la carte USB-IO => on voit :
 *
 * [lsst@lpnws4104 ~]$ lsusb
 * Bus 002 Device 001: ID 1d6b:0003 Linux Foundation 3.0 root hub
 * Bus 001 Device 003: ID 1605:8003 ACCES I/O Products, Inc.
 * Bus 001 Device 001: ID 1d6b:0002 Linux Foundation 2.0 root hub
 *
 *
 */
package org.lsst.ccs.drivers.aiousb;
