package org.lsst.ccs.drivers.aiousb.usbdio96;

import AIOUSB.*;
import static AIOUSB.AIOUSB.AIODeviceInfoGet;
import static AIOUSB.AIOUSB.DIO_ConfigureWithDIOBuf;
import static AIOUSB.AIOUSB.DIO_ReadAllToDIOBuf;
import static AIOUSB.AIOUSB_BOOL_VAL.AIOUSB_FALSE;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.BUFFER_ZERO;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.DEVICE_INDEX;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.LOAD_FAILURE;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.LOAD_SUCCESS;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.OUTPUT_MASK;

/**
 *
 * For tests.
 *
 *
 * AT LPNHE SerialNumber: 0x40e567093477dec5
 *
 * @author virieux
 */
public class TestDIO96 {

    public static long write2AllDIO(String buffer) {
        return DIO_ConfigureWithDIOBuf( DEVICE_INDEX , (short) AIOUSB_FALSE.swigValue(), OUTPUT_MASK, new DIOBuf(buffer));
    }
    
    public static DIOBuf readAllDIO() {
        DIOBuf buffer = new DIOBuf("");
        long result = DIO_ReadAllToDIOBuf(DEVICE_INDEX, buffer);
        System.out.println("result of DIO_ReadAllToDIOBuf = " + result);
        System.out.println("new buffer = " + buffer.toString());
        return buffer;
    }

    public static void main(String argv[]) throws Exception {

        boolean success = false;

        System.out.println("Loading AIOUSB64");
        long load_result = AIOUSB.AIOUSB_Init();
        System.out.println(load_result == 0 ? LOAD_SUCCESS : LOAD_FAILURE);

        System.out.println("Checking AIOUSB devices");
        long check_result = AIOUSB.AIOUSB_ListDevices();
        System.out.println("Result code is " + check_result);

        if (0 == ResultCode.AIOUSB_SUCCESS.swigValue()) {
            System.out.println(ResultCode.AIOUSB_SUCCESS);
            success = true;
        } else if (4 == ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.swigValue()) {
            System.out.println(ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND);
        }

        if (success) {
            AIODeviceInfo obj = AIODeviceInfoGet(DEVICE_INDEX);
            System.out.println("device name : " + obj.getName());
        }

        System.out.println("BUFFER_ZERO=" + BUFFER_ZERO);
        long result_configure = write2AllDIO(BUFFER_ZERO);
        System.out.println("result_configure : " + result_configure);
        readAllDIO();

        USB_DIO_96 card = new USB_DIO_96();
        card.init();
        card.simulateNoFilter();
        card.readAllDIO();
        System.out.println(card.toString());
        card.simulateFilterIsHeld();
        card.readAllDIO();
        System.out.println(card.toString());
        
    }
}
