
package org.lsst.ccs.drivers.aiousb;

import AIOUSB.AIOChannelMask;
import AIOUSB.AIOUSB;

/**
 * To store static data, enum for the aiousb project.
 *
 * @author virieux
 */
public class USB_DIO_96_Utils {
    
    public static final int MAX_DIO_BYTES = 32;

    /* There is only one USB_DIO_96 card in a standalone electronic bay*/
    public static final long DEVICE_INDEX = 0;

    public static final String LOAD_SUCCESS = "==> Library AIOUSB64 loaded with success";
    public static final String LOAD_FAILURE = "==> Could not load library AIOUSB64";
    
    /**
     * Pin localisation
     *    
     *  
     *  Group_0   => connector P2
     *  Group_1   => connector P3
     *  Group_2   => connector P4
     *  Group_3   => connector P5
     *  +5V        => PIN_49
     *  A7..A0     => PIN[33..47]
     *  B7..B0     => PIN[17..31]
     *  C7..C0     => PIN[1..15]
     * 
     *  Ports 3 and 1 , all writable
     *  Mask format
     *  "G3_PC G3_PB G3_PA" "G2_PC G2_PB G2_PA" "G1_PC G1_PB G1_PA" "G0_PC G0_PB G0_PA"
     *  "P5_C[7..0] P5_B[7..0] P5_A[7..0]" "P4_C[7..0] P4_B[7..0] P4_A[7..0]" "P3_C[7..0] P3_B[7..0] P3_A[7..0]" "P2_C[7..0] P2_B[7..0] P2_A[7..0]"

    * **/


    /*Group_0   => connector P2 */
    public static final String MSK_G0_PA = "1"; //P2_PIN[33..47] => Write
    public static final String MSK_G0_PB = "1"; //P2_PIN[17..31] => Write
    public static final String MSK_G0_PC = "1"; //P2_PIN[1..15]  => Write
    public static final String MSK_G0 = MSK_G0_PC + MSK_G0_PB + MSK_G0_PA;

    /*Group_1   => connector P3 */
    public static final String MSK_G1_PA = "1"; // P3_PIN[33..47] => Write
    public static final String MSK_G1_PB = "1"; // P3_PIN[17..31] => Write
    public static final String MSK_G1_PC = "1"; // P3_PIN[1..15]  => Write
    public static final String MSK_G1 = MSK_G1_PC + MSK_G1_PB + MSK_G1_PA;

    /*Group_2   => connector P4 */
    public static final String MSK_G2_PA = "0"; //P4_PIN[33..47] => Write
    public static final String MSK_G2_PB = "0"; //P4_PIN[17..31] => Write
    public static final String MSK_G2_PC = "0"; //P4_PIN[1..15]  => Read  ***  P4_C[7..0]
    public static final String MSK_G2 = MSK_G2_PC + MSK_G2_PB + MSK_G2_PA;

    /*Group_3   => connector P5 */
    public static final String MSK_G3_PA = "1"; //P5_PIN[33..47] => Read  ***  P5_A[7..0]
    public static final String MSK_G3_PB = "1"; //P5_PIN[17..31] => Read  ***  P5_B[7..0]
    public static final String MSK_G3_PC = "0"; //P5_PIN[1..15]  => Read  ***  P5_C[7..0]
    public static final String MSK_G3 = MSK_G3_PC + MSK_G3_PB + MSK_G3_PA;
    
    public static AIOChannelMask OUTPUT_MASK = AIOUSB.NewAIOChannelMaskFromStr(MSK_G3 + MSK_G2 + MSK_G1 + MSK_G0);
    
    public static final String BUFFER_ZERO =                                 
                                "00000000" + // Group 0 Port A   P2_A[7..0] 
                                "00000000" + //         Port B   P2_B[7..0] 
                                "00000000" + //         Port C   P2_C[7..0] 

                                "00000000" + // Group 1 Port A   P3_A[7..0] 
                                "00000000" + //         Port B   P3_B[7..0] 
                                "00000000" + //         Port C   P3_C[7..0] 

                                "00000000" + // Group 2 Port A   P4_A[7..0] 
                                "00000000" + //         Port B   P4_B[7..0] 
                                "00000000" + //         Port C   P4_C[7..0] 

                                "00000000" + // Group 3 Port A   P5_A[7..0] 
                                "00000000" + //         Port B   P5_B[7..0] 
                                "00000000";   //         Port C   P5_C[7..0]
    
    
    public enum Loader_Signal {
        PERMIT("P3_A0",64),
        PERMITb("P3_C0",48),
        ENG("P3_A1",65),
        ENGb("P3_C1",49),
        AP2("P3_A2",66),
        AP2b("P3_C2",50),
        AF0("P3_A3",67),
        AF0b("P3_C3",51),
        AF1("P3_A4",68),
        AF1b("P3_C4",52),
        AF3("P3_A5",69),
        AF3b("P3_C5",53),;
        
        String card_pin;
        int buffer_index;

        private Loader_Signal(String pin, int buffer_index) {
            this.card_pin = pin;
            this.buffer_index = buffer_index;
        }

        public String getCard_pin() {
            return card_pin;
        }

        public int getBuffer_index() {
            return buffer_index;
        }
    }
}
