
package org.lsst.ccs.drivers.aiousb;

import AIOUSB.AIODeviceInfo;
import AIOUSB.AIOUSB;
import static AIOUSB.AIOUSB.AIODeviceInfoGet;
import static AIOUSB.AIOUSB.DIO_ConfigureWithDIOBuf;
import static AIOUSB.AIOUSB.DIO_ReadAllToDIOBuf;
import static AIOUSB.AIOUSB_BOOL_VAL.AIOUSB_FALSE;
import AIOUSB.DIOBuf;
import AIOUSB.ResultCode;
import java.util.EnumSet;
import java.util.Set;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.BUFFER_ZERO;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.DEVICE_INDEX;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.LOAD_FAILURE;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.LOAD_SUCCESS;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.OUTPUT_MASK;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF0;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF0b;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF1;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF1b;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF3;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AF3b;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AP2;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.AP2b;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.ENG;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.ENGb;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.PERMIT;
import static org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils.Loader_Signal.PERMITb;

/**
 *
 * @author virieux
 */
public class USB_DIO_96 implements USB_DIO_96_Interface {

    DIOBuf buffer = new DIOBuf(BUFFER_ZERO);

    @Override
    public void init() throws Exception {
        boolean success = false;

        System.out.println("Loading AIOUSB64");
        long load_result = AIOUSB.AIOUSB_Init();
        if (load_result == 0) {
            System.out.println(LOAD_SUCCESS);
        } else {
            throw new Exception(LOAD_FAILURE);
        }

        System.out.println("Checking AIOUSB devices");
        long check_result = AIOUSB.AIOUSB_ListDevices();
        System.out.println("Result code is " + check_result);

        if (0 == ResultCode.AIOUSB_SUCCESS.swigValue()) {
            System.out.println(ResultCode.AIOUSB_SUCCESS);
            success = true;
        } else if (4 == ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.swigValue()) {
            throw new Exception(ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.name());
        }

        if (success) {
            AIODeviceInfo obj = AIODeviceInfoGet(DEVICE_INDEX);
            System.out.println("device name : " + obj.getName());
            write2AllDIO();
        }
    }

    public void readAllDIO() {
        long result = DIO_ReadAllToDIOBuf(DEVICE_INDEX, buffer);
        System.out.println("result of DIO_ReadAllToDIOBuf = " + result);
        System.out.println("new buffer ==>" + buffer.toString() + "<==");
    }

    public void write2AllDIO() {
        DIO_ConfigureWithDIOBuf(DEVICE_INDEX, (short) AIOUSB_FALSE.swigValue(), OUTPUT_MASK, buffer);
    }

    /**
     * Simulate that there is no filter at HANDOFF.
     * 
     * AP2 = 1 and  AP2b = 0
     * AF0 = 1 and  AF0b = 0
     * AF1 = 0 and  AF1b = 1
     * AF3 = 0 and  AF3b = 1
     * PERMIT = 1 and  PERMITb = 0
     * ENG = 0 and ENGb = 1
     */
    @Override
    public void simulateNoFilter() {
        System.out.println("simulateNoFilter");
        Loader_Signal[] signalList1 = new Loader_Signal[]{AP2, AF0, PERMIT, AF1b, AF3b, ENGb};
        Loader_Signal[] signalList0 = new Loader_Signal[]{AP2b, AF0b, PERMITb, AF1, AF3, ENG};
        setListOfSignals(signalList1, (short) 1);
        setListOfSignals(signalList0, (short) 0);
        write2AllDIO();
    }

    /**
     * Simulate that a filter is at HANDOFF and is held.
     * 
     * AP2 = 1 and  AP2b = 0
     * AF3 = 1 and  AF3b = 0
     * AF0 = 0 and  AF0b = 1
     * AF1 = 0 and  AF1b = 1
     * PERMIT = 1 and  PERMITb = 0
     * ENG = 0 and ENGb = 1
     **/
    @Override
    public void simulateFilterIsHeld() {
        System.out.println("simulateFilterIsHeld");
        Loader_Signal[] signalList1 = new Loader_Signal[]{AP2, AF0b, PERMIT, AF1b, AF3, ENGb};
        Loader_Signal[] signalList0 = new Loader_Signal[]{AP2b, AF0, PERMITb, AF1, AF3b, ENG};
        setListOfSignals(signalList1, (short) 1);
        setListOfSignals(signalList0, (short) 0);
        write2AllDIO();
    }

    /**
     * Set a same value in buffer for a list of signals.
     *
     * @param ls list of signals to set
     * @param valueToSet new value to be set for signals
     */
    private void setListOfSignals(Loader_Signal[] ls, short valueToSet) {
        for (Loader_Signal sig : ls) {
            buffer.set(sig.getBuffer_index(), valueToSet);
        }
    }

    @Override
    public String toString() {
        Set<Loader_Signal> l_sig = EnumSet.allOf(Loader_Signal.class);
        StringBuilder sb = new StringBuilder("Loader Signals read on card USB_DIO_96 :\n");
        int i = 1;
        for (Loader_Signal sig : l_sig) {
            sb.append(sig.name());
            sb.append(" = ");
            sb.append(buffer.get(sig.getBuffer_index()));
            String sep = i % 2 == 0 ? "\n" : " ";
            sb.append(sep);
            i++;
        }
        return sb.toString();
    }

}
