/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.aiousb;

import AIOUSB.AIODeviceInfo;
import AIOUSB.AIOUSB;
import AIOUSB.AIOUSB_BOOL_VAL;
import AIOUSB.DIOBuf;
import AIOUSB.ResultCode;
import java.util.EnumSet;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Interface;
import org.lsst.ccs.drivers.aiousb.USB_DIO_96_Utils;

public class USB_DIO_96
implements USB_DIO_96_Interface {
    DIOBuf buffer = new DIOBuf("000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");

    @Override
    public void init() throws Exception {
        boolean success = false;
        System.out.println("Loading AIOUSB64");
        long load_result = AIOUSB.AIOUSB_Init();
        if (load_result != 0L) {
            throw new Exception("==> Could not load library AIOUSB64");
        }
        System.out.println("==> Library AIOUSB64 loaded with success");
        System.out.println("Checking AIOUSB devices");
        long check_result = AIOUSB.AIOUSB_ListDevices();
        System.out.println("Result code is " + check_result);
        if (0 == ResultCode.AIOUSB_SUCCESS.swigValue()) {
            System.out.println((Object)ResultCode.AIOUSB_SUCCESS);
            success = true;
        } else if (4 == ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.swigValue()) {
            throw new Exception(ResultCode.AIOUSB_ERROR_FILE_NOT_FOUND.name());
        }
        if (success) {
            AIODeviceInfo obj = AIOUSB.AIODeviceInfoGet(0L);
            System.out.println("device name : " + obj.getName());
            this.write2AllDIO();
        }
    }

    public void readAllDIO() {
        long result = AIOUSB.DIO_ReadAllToDIOBuf(0L, this.buffer);
        System.out.println("result of DIO_ReadAllToDIOBuf = " + result);
        System.out.println("new buffer ==>" + this.buffer.toString() + "<==");
    }

    public void write2AllDIO() {
        AIOUSB.DIO_ConfigureWithDIOBuf(0L, (short)AIOUSB_BOOL_VAL.AIOUSB_FALSE.swigValue(), USB_DIO_96_Utils.OUTPUT_MASK, this.buffer);
    }

    @Override
    public void simulateNoFilter() {
        System.out.println("simulateNoFilter");
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2, USB_DIO_96_Utils.Loader_Signal.AF0, USB_DIO_96_Utils.Loader_Signal.PERMIT, USB_DIO_96_Utils.Loader_Signal.AF1b, USB_DIO_96_Utils.Loader_Signal.AF3b, USB_DIO_96_Utils.Loader_Signal.ENGb};
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2b, USB_DIO_96_Utils.Loader_Signal.AF0b, USB_DIO_96_Utils.Loader_Signal.PERMITb, USB_DIO_96_Utils.Loader_Signal.AF1, USB_DIO_96_Utils.Loader_Signal.AF3, USB_DIO_96_Utils.Loader_Signal.ENG};
        this.setListOfSignals(signalList1, (short)1);
        this.setListOfSignals(signalList0, (short)0);
        this.write2AllDIO();
    }

    @Override
    public void simulateFilterIsHeld() {
        System.out.println("simulateFilterIsHeld");
        USB_DIO_96_Utils.Loader_Signal[] signalList1 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2, USB_DIO_96_Utils.Loader_Signal.AF0b, USB_DIO_96_Utils.Loader_Signal.PERMIT, USB_DIO_96_Utils.Loader_Signal.AF1b, USB_DIO_96_Utils.Loader_Signal.AF3, USB_DIO_96_Utils.Loader_Signal.ENGb};
        USB_DIO_96_Utils.Loader_Signal[] signalList0 = new USB_DIO_96_Utils.Loader_Signal[]{USB_DIO_96_Utils.Loader_Signal.AP2b, USB_DIO_96_Utils.Loader_Signal.AF0, USB_DIO_96_Utils.Loader_Signal.PERMITb, USB_DIO_96_Utils.Loader_Signal.AF1, USB_DIO_96_Utils.Loader_Signal.AF3b, USB_DIO_96_Utils.Loader_Signal.ENG};
        this.setListOfSignals(signalList1, (short)1);
        this.setListOfSignals(signalList0, (short)0);
        this.write2AllDIO();
    }

    private void setListOfSignals(USB_DIO_96_Utils.Loader_Signal[] ls, short valueToSet) {
        for (USB_DIO_96_Utils.Loader_Signal sig : ls) {
            this.buffer.set(sig.getBuffer_index(), valueToSet);
        }
    }

    public String toString() {
        EnumSet<USB_DIO_96_Utils.Loader_Signal> l_sig = EnumSet.allOf(USB_DIO_96_Utils.Loader_Signal.class);
        StringBuilder sb = new StringBuilder("Loader Signals read on card USB_DIO_96 :\n");
        int i = 1;
        for (USB_DIO_96_Utils.Loader_Signal sig : l_sig) {
            sb.append(sig.name());
            sb.append(" = ");
            sb.append(this.buffer.get(sig.getBuffer_index()));
            String sep = i % 2 == 0 ? "\n" : " ";
            sb.append(sep);
            ++i;
        }
        return sb.toString();
    }
}

