/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAscii {
    protected final Ascii dev;

    public TestAscii() {
        this.dev = new Ascii();
    }

    public TestAscii(Ascii dev) {
        this.dev = dev;
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        this.dev.open(type, ident, param);
    }

    @Command(name="open", description="Open connection to serial device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        this.dev.open(type, ident, baud, Ascii.makeDataCharacteristics(dbits, sbits, parity, flow));
    }

    @Command(name="openold", description="Open connection to general device")
    public void openOld(@Argument(name="type", description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        int iType = type == DriverConstants.ConnType.NET ? 0 : (type == DriverConstants.ConnType.FTDI ? 1 : 2);
        this.dev.open(iType, ident, param);
    }

    @Command(name="openold", description="Open connection to serial device")
    public void openOld(@Argument(name="type", description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        int iType = type == DriverConstants.ConnType.NET ? 0 : (type == DriverConstants.ConnType.FTDI ? 1 : 2);
        this.dev.open(iType, ident, baud, Ascii.makeDataCharacteristics(dbits, sbits, parity, flow));
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(name="write", description="Write command to device")
    public void write(@Argument(name="command", description="Command to write") String command) throws DriverException {
        this.dev.write(command);
    }

    @Command(name="read", description="Read response from device")
    public String read() throws DriverException {
        return this.dev.read();
    }

    @Command(name="read", description="Write command and read response")
    public String read(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.dev.read(command);
    }

    @Command(name="timeout", description="Set read response timeout")
    public void timeout(@Argument(name="time", description="Timeout value (sec)") double time) throws DriverException {
        this.dev.setTimeout(time);
    }

    @Command(name="setterm", description="Set command terminator")
    public void setTerm(@Argument(name="term", description="Terminator string") String term) {
        char[] cTerm = new char[term.length()];
        term.getChars(0, cTerm.length, cTerm, 0);
        int jout = 0;
        for (int jin = 0; jin < cTerm.length; ++jin) {
            if (cTerm[jin] == '\\' && jin < cTerm.length - 1) {
                switch (cTerm[++jin]) {
                    case 'r': {
                        cTerm[jin] = 13;
                        break;
                    }
                    case 'n': {
                        cTerm[jin] = 10;
                        break;
                    }
                    case 't': {
                        cTerm[jin] = 9;
                        break;
                    }
                    case 'b': {
                        cTerm[jin] = 8;
                        break;
                    }
                    case 'f': {
                        cTerm[jin] = 12;
                    }
                }
            }
            cTerm[jout++] = cTerm[jin];
        }
        this.dev.setTerminator(new String(cTerm, 0, jout));
    }
}

