/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.agilent.WG33250;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestWG33250
extends TestScpi {
    private final WG33250 wg;

    public TestWG33250() {
        super((Scpi)new WG33250());
        this.wg = (WG33250)this.scpi;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") Ascii.ConnType connType, @Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.wg.open(connType, ident);
    }

    @Command(name="start", description="Start the generator")
    public void start(@Argument(name="function", description="Function name") WG33250.Function func, @Argument(name="frequency", description="Frequency (Hz)") double freq, @Argument(name="amplitude", description="Amplitude (V)") double ampl, @Argument(name="offset", description="Offset (V)") double offs) throws DriverException {
        this.wg.start(func, freq, ampl, offs);
    }

    @Command(name="setfunction", description="Set the function")
    public void setFunction(@Argument(name="function", description="Function name") WG33250.Function func) throws DriverException {
        this.wg.setFunction(func);
    }

    @Command(name="showfunction", description="Show the function")
    public String getFunction() throws DriverException {
        return "Function = " + this.wg.getFunction().name().toLowerCase();
    }

    @Command(name="setfrequency", description="Set the frequency")
    public void setFrequency(@Argument(name="frequency", description="Frequency (Hz)") double freq) throws DriverException {
        this.wg.setFrequency(freq);
    }

    @Command(name="showfrequency", description="Show the frequency")
    public String getFrequency() throws DriverException {
        return "Frequency = " + this.wg.getFrequency();
    }

    @Command(name="showfrequency", description="Show a frequency limit")
    public String getFrequency(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " frequency = " + this.wg.getFrequency(limit);
    }

    @Command(name="setamplitude", description="Set the amplitude")
    public void setAmplitude(@Argument(name="amplitude", description="Amplitude (V)") double ampl) throws DriverException {
        this.wg.setAmplitude(ampl);
    }

    @Command(name="showamplitude", description="Show the amplitude")
    public String getAmplitude() throws DriverException {
        return "Amplitude = " + this.wg.getAmplitude();
    }

    @Command(name="showamplitude", description="Show a amplitude limit")
    public String getAmplitude(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " amplitude = " + this.wg.getAmplitude(limit);
    }

    @Command(name="setoffset", description="Set the offset")
    public void setOffset(@Argument(name="offset", description="Offset (V)") double offs) throws DriverException {
        this.wg.setOffset(offs);
    }

    @Command(name="showoffset", description="Show the offset")
    public String getOffset() throws DriverException {
        return "Offset = " + this.wg.getOffset();
    }

    @Command(name="showoffset", description="Show a offset limit")
    public String getOffset(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " offset = " + this.wg.getOffset(limit);
    }

    @Command(name="sethighlevel", description="Set the high level")
    public void setHighLevel(@Argument(name="highlevel", description="High level (V)") double level) throws DriverException {
        this.wg.setHighLevel(level);
    }

    @Command(name="showhighlevel", description="Show the high level")
    public String getHighLevel() throws DriverException {
        return "High level = " + this.wg.getHighLevel();
    }

    @Command(name="showhighlevel", description="Show a high level limit")
    public String getHighlevel(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " high level = " + this.wg.getHighLevel(limit);
    }

    @Command(name="setlowlevel", description="Set the low level")
    public void setLowLevel(@Argument(name="lowlevel", description="Low level (V)") double level) throws DriverException {
        this.wg.setLowLevel(level);
    }

    @Command(name="showlowlevel", description="Show the low level")
    public String getLowLevel() throws DriverException {
        return "Low level = " + this.wg.getLowLevel();
    }

    @Command(name="showlowlevel", description="Show a low level limit")
    public String getLowlevel(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " low level = " + this.wg.getLowLevel(limit);
    }

    @Command(name="setautorange", description="Set autorange state")
    public void setOutput(@Argument(name="state", description="Autorange state name") WG33250.Autorange state) throws DriverException {
        this.wg.setAutorange(state);
    }

    @Command(name="showautorange", description="Show the autorange state")
    public String showAutorange() throws DriverException {
        return "Autorange = " + this.getOnOff(this.wg.isAutorangeOn());
    }

    @Command(name="setunit", description="Set the amplitude unit")
    public void setUnit(@Argument(name="unit", description="Unit name") WG33250.Unit unit) throws DriverException {
        this.wg.setUnit(unit);
    }

    @Command(name="showunit", description="Show the amplitude unit")
    public String getUnit() throws DriverException {
        return "Unit = " + this.wg.getUnit().name().toLowerCase();
    }

    @Command(name="setdutycycle", description="Set the square wave duty cycle")
    public void setDutyCycle(@Argument(name="dutycycle", description="Duty cycle (%)") double cycle) throws DriverException {
        this.wg.setDutyCycle(cycle);
    }

    @Command(name="showdutycycle", description="Show the square wave duty cycle")
    public String getDutyCycle() throws DriverException {
        return "Duty cycle = " + this.wg.getDutyCycle();
    }

    @Command(name="showdutycycle", description="Show a square wave duty cycle limit")
    public String getDutyCycle(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " duty cycle = " + this.wg.getDutyCycle(limit);
    }

    @Command(name="setsymmetry", description="Set the ramp symmetry")
    public void setSymmetry(@Argument(name="symmetry", description="Symmetry value (%)") double symm) throws DriverException {
        this.wg.setSymmetry(symm);
    }

    @Command(name="showsymmetry", description="Show the ramp symmetry")
    public String getSymmetry() throws DriverException {
        return "Symmetry = " + this.wg.getSymmetry();
    }

    @Command(name="showsymmetry", description="Show a ramp symmetry limit")
    public String getSymmetry(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " symmetry = " + this.wg.getSymmetry(limit);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state") OnOff state) throws DriverException {
        this.wg.setOutput(state == OnOff.ON);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.wg.isOutputOn());
    }

    @Command(name="setload", description="Set the output load")
    public void setOutputLoad(@Argument(name="load", description="Output load (ohms)") double load) throws DriverException {
        this.wg.setOutputLoad(load);
    }

    @Command(name="showload", description="Show the output load")
    public String getOutputLoad() throws DriverException {
        return "Output load = " + this.wg.getOutputLoad();
    }

    @Command(name="showload", description="Show a output load limit")
    public String getOutputLoad(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " output load = " + this.wg.getOutputLoad(limit);
    }

    @Command(name="setpolarity", description="Set the polarity")
    public void setPolarity(@Argument(name="polarity", description="Polarity name") WG33250.Polarity value) throws DriverException {
        this.wg.setPolarity(value);
    }

    @Command(name="showpolarity", description="Show the polarity")
    public String showPolarity() throws DriverException {
        return "Polarity = " + this.wg.getPolarity().name().toLowerCase();
    }

    @Command(name="setsync", description="Turn sync output on or off")
    public void setSyncOutput(@Argument(name="state", description="Sync output state") OnOff state) throws DriverException {
        this.wg.setSyncOutput(state == OnOff.ON);
    }

    @Command(name="showsync", description="Show the sync output state")
    public String showSyncOutput() throws DriverException {
        return "Sync output state = " + this.getOnOff(this.wg.isSyncOutputOn());
    }

    @Command(name="setperiod", description="Set the pulse period")
    public void setPulsePeriod(@Argument(name="period", description="Pulse period") double period) throws DriverException {
        this.wg.setPulsePeriod(period);
    }

    @Command(name="showperiod", description="Show the pulse period")
    public String getPulsePeriod() throws DriverException {
        return "Pulse period = " + this.wg.getPulsePeriod();
    }

    @Command(name="showperiod", description="Show a pulse period limit")
    public String getPulsePeriod(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " pulse period = " + this.wg.getPulsePeriod(limit);
    }

    @Command(name="setwidth", description="Set the pulse width")
    public void setPulseWidth(@Argument(name="width", description="Pulse width") double width) throws DriverException {
        this.wg.setPulseWidth(width);
    }

    @Command(name="showwidth", description="Show the pulse width")
    public String getPulseWidth() throws DriverException {
        return "Pulse width = " + this.wg.getPulseWidth();
    }

    @Command(name="showwidth", description="Show a pulse width limit")
    public String getPulseWidth(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " pulse width = " + this.wg.getPulseWidth(limit);
    }

    @Command(name="settransition", description="Set the pulse transition time")
    public void setPulseTransition(@Argument(name="transition", description="Pulse transition") double trans) throws DriverException {
        this.wg.setPulseTransition(trans);
    }

    @Command(name="showtransition", description="Show the pulse transition time")
    public String getPulseTransition() throws DriverException {
        return "Pulse transition = " + this.wg.getPulseTransition();
    }

    @Command(name="showtransition", description="Show a pulse transition time limit")
    public String getPulseTransition(@Argument(name="limit", description="Limit name") WG33250.Limit limit) throws DriverException {
        return TestWG33250.capitalize(limit.name()) + " pulse transition = " + this.wg.getPulseTransition(limit);
    }

    private static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

