/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class DL34970
extends Scpi {
    public static final int DEFAULT_BAUDRATE = 9600;

    public DL34970() {
        super(Ascii.Option.NO_NET);
    }

    public void open(Ascii.ConnType connType, String ident, int baudRate, int dataChar) throws DriverException {
        super.open(connType, ident, baudRate, dataChar);
        try {
            this.checkIdentification("HEWLETT-PACKARD", 0, "34970A", 0);
            this.writeCommand("ABORT");
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(Ascii.ConnType connType, String ident, int baudRate) throws DriverException {
        int dataChar = DL34970.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.DTR);
        this.open(connType, ident, baudRate, dataChar);
    }

    public void open(Ascii.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 9600);
    }

    public void configTC(TcType type, int[] chans) throws DriverException {
        this.writeCommand("CONF:TEMP TC," + (Object)((Object)type) + ',' + this.makeChannelList(chans));
        this.setup();
    }

    public void setScanList(int[] chans) throws DriverException {
        this.writeCommand("ROUT:SCAN" + this.makeChannelList(chans));
    }

    public double[] readData() throws DriverException {
        this.writeCommand("FORM:READ:CHAN OFF");
        return this.readDoubleArray("READ?");
    }

    public double readData(int chan) throws DriverException {
        this.writeCommand("FORM:READ:CHAN OFF;:ROUT:SCAN" + this.makeChannelList(new int[]{chan}));
        return this.readDouble(";:READ?");
    }

    public double[] readData(int[] chans) throws DriverException {
        this.writeCommand("FORM:READ:CHAN ON;:ROUT:SCAN" + this.makeChannelList(chans));
        String reply = this.readString("READ?");
        String[] words = reply.split(",");
        if (words.length != 2 * chans.length) {
            throw new DriverException("Invalid response: " + reply);
        }
        double[] values = new double[chans.length];
        for (int j = 0; j < values.length; ++j) {
            int chan;
            String word = words[2 * j + 1];
            try {
                chan = Integer.parseInt(word);
            }
            catch (NumberFormatException e) {
                throw new DriverException("Invalid integer in response: " + word);
            }
            Double value = 0.0;
            word = words[2 * j];
            try {
                value = Double.parseDouble(word);
            }
            catch (NumberFormatException e) {
                throw new DriverException("Invalid double in response: " + word);
            }
            for (int k = 0; k < chans.length; ++k) {
                if (chans[k] != chan) continue;
                values[k] = value;
                value = null;
                break;
            }
            if (value == null) continue;
            throw new DriverException("Invalid channel in response: " + chan);
        }
        return values;
    }

    private void setup() throws DriverException {
    }

    public static enum TcType {
        B,
        E,
        J,
        K,
        N,
        R,
        S,
        T;

    }
}

