/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.agilent.N6700;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestN6700
extends TestScpi {
    private N6700 n67 = (N6700)this.scpi;
    private int chanNum = 1;

    public TestN6700() {
        super(new N6700());
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.n67.open(host);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.n67.open(host, port);
    }

    @Command(name="setchannel", description="Set the current channel")
    public void setChannel(@Argument(name="channel", description="Channel number") int chan) {
        this.chanNum = chan;
    }

    @Command(name="showchannel", description="Show the set channel")
    public String getChannel() {
        return "Channel = " + this.chanNum;
    }

    @Command(name="showchaninfo", description="Show channel information")
    public String showChanInfo() throws DriverException {
        return this.showChanInfo(this.chanNum);
    }

    @Command(name="showchaninfo", description="Show channel information")
    public String showChanInfo(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        String[] info = this.n67.getChannelInfo(chan);
        return "Channel number: " + chan + "\nModel name:     " + info[0] + "\nOptions:        " + info[1] + "\nSerial number:  " + info[2];
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.n67.setVoltage(value, this.chanNum);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setVoltage(value, chan);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException {
        return "Voltage = " + this.n67.getVoltage(this.chanNum);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Voltage = " + this.n67.getVoltage(chans[0]);
        }
        return "Voltages = " + this.getString(this.n67.getVoltage(chans));
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.n67.readVoltage(this.chanNum);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Voltage = " + this.n67.readVoltage(chans[0]);
        }
        return "Voltages = " + this.getString(this.n67.readVoltage(chans));
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.n67.setVoltageLimit(value, this.chanNum);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setVoltageLimit(value, chan);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.n67.getVoltageLimit(this.chanNum);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Voltage limit = " + this.n67.getVoltageLimit(chan);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.n67.setCurrent(value, this.chanNum);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setCurrent(value, chan);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String getCurrent() throws DriverException {
        return "Current = " + this.n67.getCurrent(this.chanNum);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String getCurrent(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Current = " + this.n67.getCurrent(chans[0]);
        }
        return "Currents = " + this.getString(this.n67.getCurrent(chans));
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.n67.readCurrent(this.chanNum);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Current = " + this.n67.readCurrent(chans[0]);
        }
        return "Currents = " + this.getString(this.n67.readCurrent(chans));
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.n67.setCurrentLimit(value, this.chanNum);
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setCurrentLimit(value, chan);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "Current limit = " + this.n67.getCurrentLimit(this.chanNum);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit(@Argument(name="channel", description="Channel number") int chan) throws DriverException {
        return "Current limit = " + this.n67.getCurrentLimit(chan);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state) throws DriverException {
        this.n67.setOutput(state == OnOff.ON, this.chanNum);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state, @Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            this.n67.setOutput(state == OnOff.ON, chans[0]);
        } else {
            this.n67.setOutput(state == OnOff.ON, chans);
        }
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.n67.getOutput(this.chanNum));
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Output state = " + this.getOnOff(this.n67.getOutput(chans[0]));
        }
        boolean[] states = this.n67.getOutput(chans);
        StringBuilder text = new StringBuilder(this.getOnOff(states[0]));
        int j = 1;
        while (j < states.length) {
            text.append(", ").append(this.getOnOff(states[j]));
            ++j;
        }
        return "Output states = " + text;
    }

    @Command(name="setondelay", description="Set the output-on delay")
    public void setOnDelay(@Argument(name="time", description="Output-on delay (sec)") double time) throws DriverException {
        this.n67.setOnDelay(time, this.chanNum);
    }

    @Command(name="setondelay", description="Set the output-on delay")
    public void setOnDelay(@Argument(name="time", description="Output-on delay (sec)") double time, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setOnDelay(time, chan);
    }

    @Command(name="showondelay", description="Show the output-on delay")
    public String getOnDelay() throws DriverException {
        return "Delay = " + this.n67.getOnDelay(this.chanNum);
    }

    @Command(name="showondelay", description="Show the output-on delay")
    public String getOnDelay(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Delay = " + this.n67.getOnDelay(chans[0]);
        }
        return "Delays = " + this.getString(this.n67.getOnDelay(chans));
    }

    @Command(name="setoffdelay", description="Set the output-off delay")
    public void setOffDelay(@Argument(name="time", description="Output-off delay (sec)") double time) throws DriverException {
        this.n67.setOffDelay(time, this.chanNum);
    }

    @Command(name="setoffdelay", description="Set the output-off delay")
    public void setOffDelay(@Argument(name="time", description="Output-off delay (sec)") double time, @Argument(name="channel", description="Channel number") int chan) throws DriverException {
        this.n67.setOffDelay(time, chan);
    }

    @Command(name="showoffdelay", description="Show the output-off delay")
    public String getOffDelay() throws DriverException {
        return "Delay = " + this.n67.getOffDelay(this.chanNum);
    }

    @Command(name="showoffdelay", description="Show the output-off delay")
    public String getOffDelay(@Argument(name="channels", description="Channel numbers") String chanList) throws DriverException {
        int[] chans = this.getChannels(chanList);
        if (chans.length == 1) {
            return "Delay = " + this.n67.getOffDelay(chans[0]);
        }
        return "Delays = " + this.getString(this.n67.getOffDelay(chans));
    }

    private int[] getChannels(String chanList) throws DriverException {
        String[] parts = chanList.split(",");
        int[] chans = new int[parts.length];
        try {
            int j = 0;
            while (j < chans.length) {
                chans[j] = Integer.decode(parts[j]);
                ++j;
            }
            return chans;
        }
        catch (NumberFormatException e) {
            throw new DriverException(e.toString());
        }
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        int j = 1;
        while (j < values.length) {
            text.append(", ").append(values[j]);
            ++j;
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

