/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6700
extends Scpi
implements PowerSupplyDriver {
    public static final int VOLTAGE_MODE = 0;
    public static final int CURRENT_MODE = 1;
    public static final int CHAN_INFO_MODEL = 0;
    public static final int CHAN_INFO_OPTION = 1;
    public static final int CHAN_INFO_SERIAL = 2;
    public static final int MIN_CHANNEL = 1;
    public static final int MAX_CHANNEL = 4;
    public static final int NUM_CHANNELS = 4;
    public static final int DEFAULT_PORT = 5025;
    private int mode = 0;

    public void open(String hostname) throws DriverException {
        this.open(hostname, 5025);
    }

    public void open(String hostname, int port) throws DriverException {
        this.open(0, hostname, port);
        this.checkIdentification("Agilent", 1, "N67", 1);
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.writeAg("OUTP " + (on ? "ON" : "OFF"), chan);
    }

    public void setOutput(boolean on, int[] chan) throws DriverException {
        this.writeAg("OUTP " + (on ? "ON" : "OFF"), chan);
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.readIntegerAg("OUTP?", chan) != 0;
    }

    public boolean[] getOutput(int[] chan) throws DriverException {
        int[] iState = this.readIntegerAg("OUTP?", chan);
        boolean[] state = new boolean[iState.length];
        int j = 0;
        while (j < state.length) {
            state[j] = iState[j] != 0;
            ++j;
        }
        return state;
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.writeAg("OUTP:DEL:RISE " + time, chan);
    }

    public double getOnDelay(int chan) throws DriverException {
        return this.readDoubleAg("OUTP:DEL:RISE?", chan);
    }

    public double[] getOnDelay(int[] chan) throws DriverException {
        return this.readDoubleAg("OUTP:DEL:RISE?", chan);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.writeAg("OUTP:DEL:FALL " + time, chan);
    }

    public double getOffDelay(int chan) throws DriverException {
        return this.readDoubleAg("OUTP:DEL:FALL?", chan);
    }

    public double[] getOffDelay(int[] chan) throws DriverException {
        return this.readDoubleAg("OUTP:DEL:FALL?", chan);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeAg("VOLT " + value, chan);
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readDoubleAg("VOLT?", chan);
    }

    public double[] getVoltage(int[] chan) throws DriverException {
        return this.readDoubleAg("VOLT?", chan);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readDoubleAg("MEAS:VOLT?", chan);
    }

    public double[] readVoltage(int[] chan) throws DriverException {
        return this.readDoubleAg("MEAS:VOLT?", chan);
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeAg("CURR " + value, chan);
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readDoubleAg("CURR?", chan);
    }

    public double[] getCurrent(int[] chan) throws DriverException {
        return this.readDoubleAg("CURR?", chan);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readDoubleAg("MEAS:CURR?", chan);
    }

    public double[] readCurrent(int[] chan) throws DriverException {
        return this.readDoubleAg("MEAS:CURR?", chan);
    }

    public String[] getChannelInfo(int chan) throws DriverException {
        String[] data = new String[]{this.readStringAg("SYST:CHAN:MODEL?", chan), this.readStringAg("SYST:CHAN:OPTION?", chan), this.readStringAg("SYST:CHAN:SERIAL?", chan)};
        return data;
    }

    public void setPriorityMode(int vctype, int chan) throws DriverException {
        this.writeAg("FUNC " + (vctype == 0 ? "VOLT" : "CURR"), chan);
        this.mode = vctype;
    }

    public void setSlewRate(double rate, int chan) throws DriverException {
        this.writeAg(String.valueOf(this.mode == 0 ? "VOLT" : "CURR") + ":SLEW " + rate, chan);
    }

    public void setVoltageLimit(double limit, int chan) throws DriverException {
        this.writeAg("VOLT:LIM " + limit, chan);
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return this.readDoubleAg("VOLT:LIM?", chan);
    }

    public void setCurrentLimit(double limit, int chan) throws DriverException {
        this.writeAg("CURR:LIM " + limit, chan);
    }

    public double getCurrentLimit(int chan) throws DriverException {
        return this.readDoubleAg("CURR:LIM?", chan);
    }

    private void writeAg(String instr, int chan) throws DriverException {
        this.writeCommand(String.valueOf(instr) + "," + this.makeChannelList(chan));
    }

    private void writeAg(String instr, int[] chan) throws DriverException {
        if (chan.length == 0) {
            return;
        }
        this.writeCommand(String.valueOf(instr) + "," + this.makeChannelList(chan));
    }

    private String readStringAg(String instr, int chan) throws DriverException {
        return this.readString(String.valueOf(instr) + this.makeChannelList(chan));
    }

    private String[] readStringAg(String instr, int[] chan) throws DriverException {
        if (chan.length == 0) {
            return new String[0];
        }
        return this.readStringArray(String.valueOf(instr) + this.makeChannelList(chan));
    }

    private double readDoubleAg(String instr, int chan) throws DriverException {
        return this.readDouble(String.valueOf(instr) + this.makeChannelList(chan));
    }

    private double[] readDoubleAg(String instr, int[] chan) throws DriverException {
        if (chan.length == 0) {
            return new double[0];
        }
        return this.readDoubleArray(String.valueOf(instr) + this.makeChannelList(chan));
    }

    private int readIntegerAg(String instr, int chan) throws DriverException {
        return this.readInteger(String.valueOf(instr) + this.makeChannelList(chan));
    }

    private int[] readIntegerAg(String instr, int[] chan) throws DriverException {
        if (chan.length == 0) {
            return new int[0];
        }
        return this.readIntegerArray(String.valueOf(instr) + this.makeChannelList(chan));
    }
}

