package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 ****************************************************************************** 
 ** 
 **  Program to test the Agilent E3631 device driver
 ** 
 **  @author Heather Kelly
 ** 
 ****************************************************************************** 
 */
public class TestE3631 {

    protected E3631 ps;

    public enum OnOff {
        OFF, ON;
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    **  @param  host  The network host name
    **
    **  @throws  DriverException
    **
    *************************************************************************** 
    */
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="devId", description="The device ID of the device to open")
                     String devId,
                     @Argument(name="baud", description="baud")
                     int baud 
                     ) throws DriverException
    {
        ps.open(devId, baud);
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    **  @param  host  The network host name
    **
    **  @param  port  The network port number
    **
    **  @throws  DriverException
    **
    *************************************************************************** 
    */
    @Command(name="openftdi", description="Open FTDI connection to device")
    public void openftdi(@Argument(name="serialname", description="Serial device name")
                     String host,
                     @Argument(name="baud", description="baud")
                     int baud 
                     ) throws DriverException
    {
        ps.open(host, baud);
    }


    @Command(name = "readident", description = "read IDN")
    public String readiden() throws Exception {
        return ps.getID();
    }



}
