#! /bin/bash


#Implementation as suggested in LSSTCCS-130
osType=`uname`
if [ "$osType" == "Linux" ]
then 
    scriptFullPath=`readlink -fn $0` 
else 
    scriptFullPath=`perl -e "use Cwd 'abs_path'; print abs_path('$0')"`
fi 

# To find the full path of the script CD into the dir containing the script
binDir=$(cd "$(dirname "$scriptFullPath")"; pwd -P)

distDir=`dirname $binDir`

export CCS_DISTRIBUTION_HOME=$distDir

mainJar=$distDir/share/java/org-lsst-ccs-bootstrap-2.0.5.jar

export LD_LIBRARY_PATH=`java -cp $mainJar org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils "LD_LIBRARY_PATH"`

BOOTSTRAP_JAVA_OPTS=`java -cp $mainJar org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils "JAVA_OPTS" $@`

CLASSPATH=`java -cp $mainJar org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils "CLASSPATH" $@`

java $CCS_JAVA_OPTS $BOOTSTRAP_JAVA_OPTS -cp $CLASSPATH org.lsst.ccs.bootstrap.Bootstrap "$@"
