/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.functions;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.lsst.ccs.utilities.functions.TouchyConsumer;
import org.lsst.ccs.utilities.functions.TouchyFunction;
import org.lsst.ccs.utilities.functions.TouchySupplier;

public class Cocoon {
    public static <T extends Throwable> T forgetThrowsClause(Throwable t) throws T {
        throw t;
    }

    public static <X, T extends Throwable> Consumer<X> consumer(final TouchyConsumer<X, T> touchyConsumer) throws T {
        Objects.requireNonNull(touchyConsumer);
        return new Consumer<X>(){

            @Override
            public void accept(X t) {
                try {
                    touchyConsumer.accept(t);
                }
                catch (Throwable exc) {
                    Cocoon.forgetThrowsClause(exc);
                }
            }
        };
    }

    public static <X, R, T extends Throwable> Function<X, R> function(final TouchyFunction<X, R, T> touchyFunction) throws T {
        Objects.requireNonNull(touchyFunction);
        return new Function<X, R>(){

            @Override
            public R apply(X x) {
                try {
                    return touchyFunction.apply(x);
                }
                catch (Throwable exc) {
                    Cocoon.forgetThrowsClause(exc);
                    return null;
                }
            }
        };
    }

    public static <R, T extends Throwable> Supplier<R> supplier(final TouchySupplier<R, T> touchySupplier) throws T {
        Objects.requireNonNull(touchySupplier);
        return new Supplier<R>(){

            @Override
            public R get() {
                try {
                    return touchySupplier.get();
                }
                catch (Throwable exc) {
                    Cocoon.forgetThrowsClause(exc);
                    return null;
                }
            }
        };
    }
}

