/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dispatch;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.lsst.ccs.utilities.dispatch.ASyncObserver;
import org.lsst.ccs.utilities.dispatch.PackCst;

public class ParallelObservable<P> {
    protected CopyOnWriteArrayList<ASyncObserver<P>> list = new CopyOnWriteArrayList();
    protected ExecutorService loop;

    public ParallelObservable() {
        this.loop = PackCst.EXECUTOR_SERVICE;
    }

    public ParallelObservable(ExecutorService execService) {
        this.loop = execService;
    }

    public void addObserver(ASyncObserver<P> observer) {
        this.list.add(observer);
    }

    public void removeObserver(ASyncObserver<P> observer) {
        this.list.remove(observer);
    }

    public void notifyObservers(P data) {
        for (ASyncObserver<P> observer : this.list) {
            this.loop.submit(new DoUpdate<P>(observer, data));
        }
    }

    static class DoUpdate<P2>
    implements Runnable {
        public final ASyncObserver<P2> executant;
        public final P2 data;

        DoUpdate(ASyncObserver<P2> executant, P2 data) {
            this.executant = executant;
            this.data = data;
        }

        @Override
        public void run() {
            try {
                this.executant.update(this.data);
            }
            catch (Exception exc) {
                PackCst.CURLOG.log(Level.SEVERE, "while executing :", exc);
            }
        }
    }
}

